# Initialization of resources and global variables (i.e. not tied to a specific
# character's dialogue tree) 
# Includes things like character sprites and backgrounds, for easy reference.
   
# Global game setup, initializes some of the singleton classes, as well as error
# tracking, and importing all our Python modules.
init 2 python :                

    # Modify stderr to print to a log rather than to crash the game (except in
    # extreme cases) 
    from datetime import datetime
    sys.stderr = open('dinocracy.log', 'a')
    sys.stderr.write("\n========================================\nDINOCRACY\n")
    sys.stderr.write("%s\n" % datetime.now())
    
    # Import our custom classes and code.
    from NPC import *
    from NPCController import *
    from Planner import *
    from PlannerData import *
    from Player import *
    from Tooltip import *
    from random import *
  
    # Since some of our tests exercise Renpy code, we have to do the tests
    #in-game. Load the test suite, run the tests. Results are printed to stderr. 
    from TestSuite import *
    runTestSuite()
    
    # Initialize these now so that the game doesn't crash on the menus.
    # DO NOTE you will have to re-define them in GameStart.rpy in order to
    # get them to save.
    myPlayer = Player()
    myPlanner = Planner(myPlayer)
    npcControl = NPCController(True)
    
    printMissingTrees()

    # Override default narrator and player character
    you = DynamicCharacter("myPlayer.getName()", color="#ffffff", ctc = 
    anim.Blink("resource/nextArrow.png"),callback=callback)
    planner = getNPC("planner").getCharacter()
    narrator = Character(color="#eeeeee", 
    ctc = anim.Blink("resource/nextArrow.png"),
    callback=callback)     
    
    # Extra positions
    offright = Position(xpos=1.0, xanchor='left')
    offleft = Position(xpos=0.0, xanchor='right')  
    
    # Icon
    config.window_icon = "resource/dinocracyicon.png"
    
    ## The background of the main menu. This can be a color
    ## beginning with '#', or an image filename. The latter
    ## should take up the full height and width of the screen.
    theme.bordered.mm_root = "resource/dinocracy.png"

    ## The background of the game menu. This can be a color
    ## beginning with '#', or an image filename. The latter
    ## should take up the full height and width of the screen.
    theme.bordered.gm_root = "resource/BG/planningBG.png"
init 3:

    # Here we define the backgrounds that are used.
    image bg title = "resource/BG/dinocracy.png"
    image bg wakeupBG = "resource/BG/room.png"
    image bg nightBG = "resource/BG/room_night.png"
    image bg plannerBG = "resource/BG/planningBG.png"
    image bg crowdBG = "resource/BG/fundraise.png"
    image bg coffeeBG = "resource/BG/coffee.png"
    image bg readingBG = "resource/BG/library.png"
    image bg golfBG = "resource/BG/golfcourse.png"
    image bg plannerBG_main = "resource/BG/plannerBG_main.png"
    image bg plannerBG_sub = "resource/BG/plannerBG_sub.png"

    
    
