# All functions that are 'global' in this game, mainly for easier calling in Ren'py scripts.

init 1 python : 
    # A Python-level version of the NPCController.getNPC() function.
    # INPUT: [name] The variable name of the NPC desired.
    # OUTPUT: The NPC object corresponding to the NPC desired. 
    def getNPC(name):
        return npcControl.getNPC(name)
        
    # A debug method that prints to log all dialogue trees that are missing. 
    # OUTPUT: none    
    def printMissingTrees():    
        testPlannerData = PlannerData()
        sys.stderr.write("Beginning dialogue tree check.\n")
        for npcName in npcControl.getAllNames() :
            npc = getNPC(npcName)
            
            if npcName == 'planner' :
                pass
            
            elif npcName == "none": # player character    
                for act in testPlannerData.getActivities("morning") :
                    activity = "player_" + act
                    if act in testPlannerData.groupActivities == False and  renpy.has_label(activity) == False :
                        sys.stderr.write("Missing label dialogue: %s\n" % activity)
                for act in testPlannerData.getActivities("afternoon") :
                    activity = "player_" + act
                    if act in testPlannerData.groupActivities == False and renpy.has_label(activity) == False :
                        sys.stderr.write("Missing label dialogue: %s\n" % activity)           
                        
            else : #npc character
                for act in testPlannerData.getActivities("morning")  :
                    activity = npcName + "_" + act
                    if act in testPlannerData.groupActivities and renpy.has_label(activity) == False :
                        sys.stderr.write("Missing label dialogue: %s\n" % activity) 
                for act in testPlannerData.getActivities("afternoon"):
                    activity = npcName + "_" + act
                    if act in testPlannerData.groupActivities and renpy.has_label(activity) == False :
                        sys.stderr.write("Missing label dialogue: %s\n" % activity)       
                for integ in range(0, 6) :
                    activity = npcName + ("_%s" % integ)
                    if renpy.has_label(activity) == False :
                        sys.stderr.write("Missing label dialogue: %s\n" % activity)       
        sys.stderr.write("Dialogue tree check done.\n")
                        
# Display a notification that one's stats have changed, then actually update it.
# INPUT: [_stat] The name of the stat to change.
# [_delta] The amount to change the stat by.
# OUTPUT: none
label changeStats(stat, delta) :
    python :          
        statDialogue = myPlayer.changeStats(stat, delta) 
        for dialogueLine in statDialogue : 
           renpy.say(None, dialogueLine)  
    return
    
# Display a notification that one's relationship has changed, then actually
# update it.
# INPUT: [_stat] The variable name of the NPC related.
# [_delta] The amount to change the relationship by.
# OUTPUT: none
label changeRelationship(person, delta) :
    python :
        relaDialogue = getNPC(person).changeRelationship(delta) 
        for dialogueLine in relaDialogue :
           renpy.say(None, dialogueLine) 
    return            
    
            
            
