# This file adds a number of buttons to the upper-right hand corner of
# the screen. Three of these buttons jump to the game menu, which
# giving quick access to Load, Save, and Prefs. The fourth button
# toggles skipping, to make that more convenient.

# http://renpy.org/wiki/renpy/doc/cookbook/Button_Game_Menu

init python:

    # Give us some space on the right side of the screen.
    style.window.right_padding = 100

    def toggle_skipping():
        config.skipping = not config.skipping

    show_button_game_menu = True

    def button_game_menu():
        
        if show_button_game_menu:

            # to save typing
            ccinc = renpy.curried_call_in_new_context

            ui.vbox(xpos=0.99, ypos=0.01, xanchor='right', yanchor='top')
            #ui.textbutton("Skip", clicked=toggle_skipping, xminimum=80)
            #ui.textbutton("Save", clicked=ccinc("_game_menu_save"), xminimum=80)
            #ui.textbutton("Load", clicked=ccinc("_game_menu_load"), xminimum=80)
            ui.textbutton("Menu", clicked=ccinc("_game_menu_preferences"), xminimum=80)
            ui.close()


    config.window_overlay_functions.append(button_game_menu)
