# This is the Ren'py code for actually interacting with the planner.

# This is the label that -actually- calls the planner.
# Separated so that it can be called repeatedly (if the player decides to revise their plans.)
# The actual planner menu is coded in Python and is found at Planner.py.
label plannerMenu:
    
    # set default values for day planner and then call day planner.
    $ myPlanner.initialize()
    
    scene bg plannerBG_main with slideleft
    call plannerPlanning
    # Return to gameLoopActivities in GameLoop.rpy, theoretically
    jump gameLoopActivities # note: return ends the game UNLESS it is called from a 'call' branch rather than a 'jump'
        
# The planning loop. This will show whatever menu the Planner class is currently on
# until "Start Day" is clicked, at which point we return back to the game loop.
label plannerPlanning:
    scene bg plannerBG_main
    show planner normal at right
    
    # mychoice tells you what button is clicked on
    $ mychoice = myPlanner.mainmenu()
    
    if mychoice == "planMorningActivity" :
        scene bg plannerBG_sub
        show planner normal at right
        $ myPlanner.planActivity("morning")
        
    elif mychoice == "planMorningPerson" :
        scene bg plannerBG_sub
        show planner normal at right
        $ myPlanner.planPerson(myPlanner.getPlanMap()['planMorning'])
        
    elif mychoice == "planAfternoonActivity" :
        scene bg plannerBG_sub
        show planner normal at right
        $ myPlanner.planActivity("afternoon")
        
    elif mychoice == "planAfternoonPerson" :
        scene bg plannerBG_sub
        show planner normal at right
        $ myPlanner.planPerson(myPlanner.getPlanMap()['planAfternoon'])
        
    elif mychoice == "done" :
        show planner happy
        planner "Got it. Let's do our best today!"
        return

    jump plannerPlanning 

