import renpy.store as store
import renpy.exports as renpy

class PlannerData():
    '''
    The data side of the day planner.
    While Planner.py is more visual, dealing with displaying the actual menu, this is where 
    lists such as all possible / unlocked activites are stored.
    '''
    
     # Initialize activities!
    def __init__(self):
        '''
        Constructor.
        Initializes unlocked activities and NPCs to their default values.
    
        OUTPUT: none (constructor)
        '''
        self. __activities = {
            'morning'   : ['coffee', 'read', 'fundraise'],
            'afternoon' : ['golf', 'practice', 'fundraise']
            } 
            
        # NPCs it is possible to interact with
        self. __NPCs = ['dinoPres', 'leadRobo', "pteradude", "gramps"]
        self.__relationshipAdj = ['Passersby', 'Acquaintances',
        'Good acquaintances', 'Friends', 'Good friends', 'Best friends']
        
        ###
        # Things that aren't likely to change
        ###
        self.planIconDisabled = "resource/plannerMenu/disabled.png"
        
        self.activityIconPath = "resource/plannerMenu/activities/"
        self.peopleIconPath   = "resource/plannerMenu/people/"

        # All possible activities and NPCs.
        self.allNPCs = ['dinoPres', 'leadRobo', "pteradude", "gramps"]
        
        # Activities that you do with other people
        self.groupActivities = ['coffee', 'golf']
        
        self.allActivities = {
            'morning'   : ['coffee', 'read', 'fundraise', 'unavail1', 'unavail2',
                            'unavail3'],
            'afternoon' : ['golf', 'practice', 'fundraise', 'unavail1', 'unavail2',
                            'unavail3']
        }
        
        # DESCRIPTIONS OF ACTIVITIES
        
        # Verbs corresponding to an activity
        self.activityVerb = {
            'coffee'    : "drinking coffee",
            'read'      : "reading the paper",
            'golf'      : "golfing",
            'fundraise' : "fundraising"
        }
        # Descriptions of activities
        self.activityDescription = {
            'coffee': "Having coffee together is a nice way to start your morning!",
            'read'  : "Reading the paper will keep you up-to-date with events!",
            'golf'  : "Golfing is a nice leisure activity to do with a friend!",
            'practice' : "Practicing your speeches will make you more confident!",
            'fundraise': "Fundraising is a great way to raise money for your cause!"
        }
    
    def getRelationshipAdj(self) :
        ''' 
        OUTPUT: The list of adjectives describing relationship levels. 
        '''
        return self.__relationshipAdj
        
    def getActivities(self, timePeriod):
        ''' 
        INPUT: [timePeriod] The time period for which you want the available activities.
        OUTPUT: The list of all possible activities for the given time period. 
        '''
        return self.__activities[timePeriod] 
        
    def getNPCs(self):
        ''' 
        OUTPUT: The list of all possible NPCs that can be interacted with. (plaintext variable names) 
        '''
        return self.__NPCs
        
    def unlockNPC(self, npc) :
        ''' 
        Unlocks an NPC for selection in the day planner. 
        INPUT: [_npc] The variable name of the NPC to unlock.
        OUTPUT: none '''
        self.__NPCs.append(npc)
        
    def lockNPC(self, npc) :
        '''
        Locks an NPC, making it unavailable for selection in the day planner.
        INPUT: [_npc] The variable name of the NPC to be locked.
        OUTPUT: none'''
        self.__NPCs.remove(npc)   
        
    def unlockActivity(self, period, activity) :
        ''' 
        Unlocks an activity for selection in the day planner.
        INPUT: [_period] The time period for which you want to unlock the activity. 
        [_activity] The activity you wish to unlock. 
        OUTPUT: none
        '''
        self.__activities[period].append(activity)
    
        
        
