import unittest
from NPC import *
from Player import *

class TestNPC(unittest.TestCase):

    def getSuite():
        return unittest.TestLoader().loadTestsFromTestCase(WidgetTestCase)  

    def setUp(self):
        ''' This is run before each test in this class. '''
        self.npc = NPC("President", "dinoPres")
        self.player = Player()

    def tearDown(self):
        ''' This is run after each test in this class. '''
        self.npc = None
        self.player = None

    # All tests methods MUST be prefixed with test_ to be recognized.
    
    # Test to make sure default stats for NPC are initialized properly.
    def test_defaultStats(self):
        relat = self.npc.getRelationship()
        assert relat == 0
        
    # Test to make sure going below minimum value for stats works properly.
    def test_minStats(self):
        relat = self.npc.getRelationship()
        assert relat == 0
        self.npc.changeRelationship(-1000) #set it to below 0, what should be MIN_RELATIONSHIP
        relat = self.npc.getRelationship()
        assert relat == 0
        
    # Test to make sure going below maximum value for stats works properly.    
    def test_maxStats(self):
        relat = self.npc.getRelationship()
        assert relat == 0
        self.npc.changeRelationship(1000) #set it to above 5, what should be MAX_RELATIONSHIP
        relat = self.npc.getRelationship()
        assert relat == 5
        
    # Test to make sure persuasion weights are initialized properly.
    def test_defaultPersuasion(self) :
        weights = self.npc.getPersuasionWeights()
        assert weights == [0.333, 0.333, 0.333]
        
    # Test to make sure persuasion weights can be changed properly.    
    def test_changePersuasion(self):
        self.npc.setPersuasionWeights(0.5, 0.25, 0.25)
        weights = self.npc.getPersuasionWeights()
        assert weights == [0.5, 0.25, 0.25]
        
    # Test to make sure persuasion weights, if out of proportion, are rescaled properly.
    def test_changePersuasionScaled(self):
        self.npc.setPersuasionWeights(2, 1, 1)
        weights = self.npc.getPersuasionWeights()
        assert weights == [0.5, 0.25, 0.25]
        
    # A sample test to make sure that a given stat and day setup passes a persuasion check.
    def test_successPersuasion(self):    
        self.npc.setPersuasionWeights(2, 1, 1)
        self.npc.setRelationship(3)
        day = 4
        stats = [10, 6, 6]
        assert self.npc.persuade(stats, day) == True
        
    # A sample test to make sure that a given stat and day setup ties and therefore passes a persuasion check.    
    def test_tiePersuasion(self):    
        self.npc.setPersuasionWeights(2, 1, 1)
        self.npc.setRelationship(3)
        day = 4
        stats = [10, 10, 10]
        assert self.npc.persuade(stats, day) == True
        
    # A sample test to make sure that a given stat and day setup fails a persuasion check.    
    def test_failPersuasion(self):    
        self.npc.setPersuasionWeights(2, 1, 1)
        self.npc.setRelationship(3)
        day = 4
        stats = [10, 4, 4]
        assert self.npc.persuade(stats, day) == True    
