import unittest
from NPCController import *
from NPC import * 
class TestNPCController(unittest.TestCase):

    def getSuite(self):
        return unittest.TestLoader().loadTestsFromTestCase(WidgetTestCase)  

    def setUp(self):
        '''This is run before each test in this class.'''
        self.control = NPCController(True)

    def tearDown(self):
        '''This is run after each test in this class.'''
        self.control = None

    # All tests methods MUST be prefixed with test_ to be recognized.
    
    # Testing to make sure NPCController inits and returns NPCs properly.
    def test_getNPC(self):
        gramps = self.control.getNPC("gramps")
        planner = self.control.getNPC("planner")
        leadRobo = self.control.getNPC("leadRobo")
        assert gramps.getName() == "Mr. Velocigramps"
        assert planner.getName() == "Plannersaurus"
        assert leadRobo.getName() == "Leader-Bot 3.0"
        
    # Testing to make sure the list of NPC names is returned properly    
    def test_getKeys(self):
        keys = self.control.getAllNames()
        assert keys.contains("dinoPres")
        assert keys.contains("pteradude")
        assert keys.contains("planner")

