import unittest
from Planner import *

class TestPlanner(unittest.TestCase):

    def getSuite(self):
        return unittest.TestLoader().loadTestsFromTestCase(WidgetTestCase)  

    def setUp(self):
        ''' This is run before each test in this class. '''
        self.planner = Planner()

    def tearDown(self):
        ''' This is run after each test in this class. '''
        self.planner = None

    # All tests methods MUST be prefixed with test_ to be recognized.
    
    # Test to make sure incrementing the day works properly.
    def test_incDay(self):
        day1 = self.planner.getDay()
        self.planner.incrementDay()
        day2 = self.planner.getDay()
        assert day1 + 1 == day2
        
    # Test to make sure unlocking an NPC works properly.    
    def test_unlockNPC(self):
        npcs = self.planner._Planner__plannerData.getNPCs()
        assert npcs.contains("shiori") == False
        self.planner.unlockNPC("shiori")
        npcs = self.planner._Planner__plannerData.getNPCs()
        assert npcs.contains("shiori")
        
    # Test to make sure relocking an NPC works properly.    
    def test_unlockNPC(self):
        npcs = self.planner._Planner__plannerData.getNPCs()
        assert npcs.contains("dinoPres") 
        self.planner.unlockNPC("dinoPres")
        npcs = self.planner._Planner__plannerData.getNPCs()
        assert npcs.contains("dinoPres") == False    
        
    # Test to make sure unlocking an activity works properly.    
    def test_unlockActivity(self) :
        mornAct = self.planner._Planner__plannerData.getActivities("morning")
        afterAct = self.planner._Planner__plannerData.getActivities("afternoon")
        assert mornAct.contains("technika") == False
        assert afterAct.contains("technika") == False
        self.planner.unlockActivity("morning", "technika")
        mornAct = self.planner._Planner__plannerData.getActivities("morning")
        afterAct = self.planner._Planner__plannerData.getActivities("afternoon")
        assert mornAct.contains("technika")
        assert afterAct.contains("technika") == False    
        
    # Testing to make sure a plan with partner activities, but no partners is not valid.
    def test_validPlan(self) :
        self.planner._Planner__planMorning = "coffee"
        self.planner._Planner__planAfternoon = "golf"
        self.planner._Planner__partnerMorning = self.planner.noSelection
        self.planner._Planner__partnerAfternoon = self.planner.noSelection
        assert self.planner.validPlan == False
        
    # Testing to make sure a plan with solo activities, but no partners is valid.    
    def test_validPlan2(self) :
        self.planner._Planner__planMorning = "read"
        self.planner._Planner__planAfternoon = "practice"
        self.planner._Planner__partnerMorning = self.planner.noSelection
        self.planner._Planner__partnerAfternoon = self.planner.noSelection
        assert self.planner.validPlan

    # Testing to make sure a plan with partner activities and partners is valid. 
    def test_validPlan3(self) :
        self.planner._Planner__planMorning = "coffee"
        self.planner._Planner__planAfternoon = "golf"
        self.planner._Planner__partnerMorning = "dinoPres"
        self.planner._Planner__partnerAfternoon = "leadRobo"
        assert self.planner.validPlan
        
    # Testing to make sure a plan with solo activities WITH partners is not valid.    
    def test_validPlan4(self) :
        self.planner._Planner__planMorning = "coffee"
        self.planner._Planner__planAfternoon = self.planner.noSelection
        self.planner._Planner__partnerMorning = "dinoPres"
        self.planner._Planner__partnerAfternoon = "leadRobo"
        assert self.planner.validPlan == False
        

