import unittest
from PlannerData import *

class TestPlannerData(unittest.TestCase):

    def getSuite(self):
        return unittest.TestLoader().loadTestsFromTestCase(WidgetTestCase)  

    def setUp(self):
        ''' This is run before each test in this class. '''
        self.pData = PlannerData()
        
    def tearDown(self):
        ''' This is run after each test in this class. '''
        self.pData = None

    # All tests methods MUST be prefixed with test_ to be recognized.
    
    # Test to make sure unlocking an NPC works properly.
    def test_unlockNPC(self):
        npcs = self.pData.getNPCs()
        assert npcs.contains("shiori") == False
        self.pData.unlockNPC("shiori")
        npcs = self.pData.getNPCs()
        assert npcs.contains("shiori")                 
        
    # Test to make sure relocking an NPC works properly.    
    def test_lockNPC(self):
        npcs = self.pData.getNPCs()
        assert npcs.contains("dinoPres")
        self.pData.unlockNPC("dinoPres")
        npcs = self.pData.getNPCs()
        assert npcs.contains("dinoPres") == False
        
    # Test to make sure unlocking an activity works properly.    
    def test_unlockActivity(self) :
        mornAct = self.pData.getActivities("morning")
        afterAct = self.pData.getActivities("afternoon")
        assert mornAct.contains("technika") == False
        assert afterAct.contains("technika") == False
        self.pData.unlockActivity("morning", "technika")
        mornAct = self.pData.getActivities("morning")
        afterAct = self.pData.getActivities("afternoon")
        assert mornAct.contains("technika")
        assert afterAct.contains("technika") == False

