import unittest
from Player import *

class TestPlayer(unittest.TestCase):

    def getSuite(self):
        return unittest.TestLoader().loadTestsFromTestCase(WidgetTestCase)  

    # This is run before each test in this class.
    def setUp(self):
        self.player = Player()

    # This is run after each test in this class.
    def tearDown(self):
        self.player = None

    # All tests methods MUST be prefixed with test_ to be recognized.
    
    # Test to make sure the stats initialize properly.
    def test_defaultStats(self):
        stats = self.player.getStats()
        assert stats['money'] == 2
        assert stats['charm'] == 2
        assert stats['intelligence'] == 2
        
    # Test to make sure the stats handle minimum values properly.   
    def test_minStats(self):
        stats = self.player.getStats()
        assert stats['money'] == 2
        self.player.changeStats('money', -1000) # set it to below 0, what should be MIN_STAT
        stats = self.player.getStats()
        assert stats['money'] == 0
        
    # Test to make sure the stats handle maximum values properly.    
    def test_maxStats(self):
        stats = self.player.getStats()
        assert stats['money'] == 2
        self.player.changeStats('money', 1000) # set it to above 100, what should be MAX_STAT
        stats = self.player.getStats()
        assert stats['money'] == 20
        
