# http://stackoverflow.com/questions/1732438/run-all-unit-test-in-python-directory

import glob
import unittest
import sys

def runTestSuite() :   
    testSuite = unittest.TestSuite()
    
    module_strings = ['TestNPC', 'TestNPCController', 'TestPlanner', 'TestPlannerData', 'TestPlayer', 'TestTooltip']
    
    suite = unittest.TestSuite()

    for t in module_strings:
        try:
            # If the module defines a getSuite() function, call it to get the suite.
            sys.stderr.write("Loading %s\n" % t)
            mod = __import__(t, globals(), locals(), ['getSuite'])
            suitefn = getattr(mod, 'getSuite')
            suite.addTest(suitefn())
        except (ImportError, AttributeError):
            # else, just load all the test cases from the module.
            #sys.stderr.write("[getSuite() not found, using default]\n")
            suite.addTest(unittest.defaultTestLoader.loadTestsFromName(t))
    
    unittest.TextTestRunner(stream=sys.stderr, verbosity=2).run(suite)
