import renpy.store as store
import renpy.exports as renpy



class Tooltip(object):
    ''' A small little subclass used in Planner, which was provided by some searching on the Ren'py forums.
    Can make a small visual tooltip appear and dissappear on screen. '''
    
    def __init__(self, x, y, message):
        ''' Constructor.
        
        INPUT: [x] x position of tooltip
        [y] y position of tooltip
        [message] string displayed in tooltip'''
        self.x = x
        self.y = y
        self.message = message
       
        self.tip = None
    
    def show(self):
        ''' Makes the tooltip display itself. '''
        self.tip = store.ui.frame(xpos=self.x, ypos=self.y)
        store.ui.text(self.message)
        renpy.restart_interaction()
       
    def hide(self):
        ''' Makes the tooltip hide itself.  '''
        if self.tip:
            store.ui.remove(self.tip)
            renpy.restart_interaction()
            self.tip = None
