# http://www.renpy.org/doc/html/screens.html
# http://www.renpy.org/doc/html/screen_actions.html
# http://labs.coldacid.net/code/simple-scene-library-renpy

label debugmenu_namechara:
    $ myPlayer.setName(renpy.input("Please enter your candidate's name:", default=myPlayer.getName()).strip())
    call screen debug
    return
    
label debugmenu_changestats:
    #$ myPlayer.changeStats(persistent.debugstat, persistent.debugdelta)
    $ myPlayer.setStats(persistent.debugstat, 
        int(renpy.input("Please enter the value for %s:" % persistent.debugstat, allow="1234567890", default=myPlayer.getStats()[persistent.debugstat])))
    call screen debug
    return
    
label debugmenu_changeday:
    $ myPlanner.setDay(int(renpy.input("Please enter the value for the day:", allow="1234567890", default=myPlanner.getDay())))
    call screen debug
    return
    
label debugmenu_jump :
    $ debugActivity = True
    $ debugmenu_jumplabel()
    $ debugActivity = False        
    call screen debug
    return
    
label debugmenu_relationship :
    $ npcName = debugmenu_changerelationship()
    if npcName != False :
        $ thisNPC = npcControl.getNPC(npcName)
        $ curRel = thisNPC.getRelationship()
        $ thisNPC.setRelationship(int(renpy.input("Please enter the relationship value for %s:" % npcName, allow="1234567890", default=curRel)))
    call screen debug    
    return

init:
    $ persistent.debugstat= 'none'
    $ persistent.debugdelta = 0
    $ debugActivity = False
    
init python :
    def debugmenu_jumplabel() :
        labelList = []
        for i in renpy.get_all_labels():
            if i.startswith("_") == False :
                labelList.append(i)
     
        labelList.sort()

        ui.frame(xalign=0.5, yalign=0.15, xanchor='center', yanchor='top')
        ui.side(['c', 'r'], spacing=5)
        vp = ui.viewport(draggable=True, clipping=True, mousewheel=True, xmaximum=560, ymaximum=490)
        ui.vbox()
        
        for i in labelList:
            ui.textbutton(i, clicked=ui.jumps(i))

        ui.close()
        ui.bar(adjustment=vp.yadjustment, style='vscrollbar', yalign=0.9)
        ui.close()
       
        # And now, a button to bring us back to the main menu.
        ui.textbutton('Return', xalign = 0.5, ypos = 550, clicked = ui.returns(False), size_group = 'scene')
       
        # This pretty much says to take us back to the main menu if 'Return' is
        # clicked, or rebuild the dialog if we've just come back from a scene.
        
        ui.interact()
        return
        
    def debugmenu_changerelationship() :
        labelList = npcControl.getAllNames()
        labelList.sort()

        ui.frame(xalign=0.5, yalign=0.15, xanchor='center', yanchor='top')
        ui.side(['c', 'r'], spacing=5)
        vp = ui.viewport(draggable=True, clipping=True, mousewheel=True, xmaximum=560, ymaximum=490)
        ui.vbox()
        
        for i in labelList:
            ui.textbutton(i, clicked=ui.returns(i))

        ui.close()
        ui.bar(adjustment=vp.yadjustment, style='vscrollbar', yalign=0.9)
        ui.close()
       
        # And now, a button to bring us back to the main menu.
        ui.textbutton('Return', xalign = 0.5, ypos = 550, clicked = ui.returns(False), size_group = 'scene')
       
        # This pretty much says to take us back to the main menu if 'Return' is
        # clicked, or rebuild the dialog if we've just come back from a scene.
        return ui.interact()
        
screen debug:

    tag menu

    # Include the navigation.
    use navigation
    
    # Put the navigation columns in a three-wide grid.
    grid 1 1:
        style_group None
        xfill True
        
        vbox:
            frame:
                
                has vbox

                label _("Dinocracy Debug Menu")
                label _("")
                textbutton "Jump to Label" action Jump("debugmenu_jump")
                textbutton "Change Relationship" action Jump("debugmenu_relationship")
                label _("")
                
                #hbox :
                #    label _("Name: %s" % (myPlayer.getName()))
                #    textbutton "Change" action Jump("debugmenu_namechara")    
                
                # change day, change relationship
                hbox :
                    label _("Day: %s" % (myPlanner.getDay()))
                    textbutton "Change" action [Jump("debugmenu_changeday")]
                    
                hbox :
                    label _("Money: %s" % (myPlayer.getStats()['money']))
                    textbutton "Change" action [SetField(persistent, 'debugstat', 'money'), Jump("debugmenu_changestats")]
                   
                hbox :
                    label _("Intelligence: %s" % (myPlayer.getStats()['intelligence']))
                    textbutton "Change" action [SetField(persistent, 'debugstat', 'intelligence'), Jump("debugmenu_changestats")]
                    
                hbox :
                    label _("Charm: %s" % (myPlayer.getStats()['charm']))
                    textbutton "Change" action [SetField(persistent, 'debugstat', 'charm'), Jump("debugmenu_changestats")]
                  
                    

