screen save:

    # This ensures that any other menu screen is replaced.
    tag menu

    use navigation

    frame:
        has vbox

        # The buttons at the top allow the user to pick a
        # page of files.
        hbox:
            label _("Save Game")
            textbutton _("Switch to Load") action ShowMenu("load")
            textbutton _("Previous") action FilePagePrevious()
            #textbutton _("Auto") action FilePage("auto")

            for i in range(1, 5):
                textbutton str(i) action FilePage(i)

            textbutton _("Next") action FilePageNext()

        # Display a grid of file slots.
        grid 1 5:
            transpose True
            xfill True

            # Display five file slots, numbered 1 - 6.
            for i in range(1, 6):

                # Each file slot is a button.
                button:
                    action FileAction(i)
                    xfill True
                    style "large_button"

                    has hbox

                    # Add the screenshot and the description to the
                    # button.
                    add FileScreenshot(i)
                    text ( " %2d. " % i
                           + FileTime(i, empty=_("Empty Slot."))
                           + "\n"
                           + FileSaveName(i)) style "large_button_text"