# Activity Template
# 
# Creator: Benson
# Last Edited: 
##########

# Pick a nice label here
label activity_template:
    # If you want to do randomly-generated dialogue paths, use this!
    $ randomChoice = choice(range(1))
    
    # Always use a transition when changing background
    # In this case, we'll use fade (which looks nice)
    scene bg wakeupBG with fade
    
    # Get player name
    $name = myPlayer.getName()
    
    # Remember that this is the one that calls the methods...
    # but the call name corresponds to the renpy scene characters
    # We'll use the president for this one
    $TheNPC = getNPC("dinoPres")
    
    # This is the character that speaks.  Don't get confused!
    $the_npc = TheNPC.getCharacter()

##########
    
    # Putting the characters on screen
    show dinoPres normal at offright with None
    show you normal at offleft with None
    
    # Moving them onto the screen with ease
    show dinoPres normal at right
    show you normal at left
    with ease
    
    # Example dialogue
    # Note you don't have to specify position if they're in the right spot already
    show dinoPres happy 
    the_npc "So good to see you!"
    show you confused
    you "Where are we?"
    show dinoPres normal
    
    # Referencing player name with %(name)s
    the_npc "Why hello there, %(name)s! You're just in time for the preview of our template file."
    show you normal
    you "I see..."
    the_npc "Well, let's take a look around!"
    
    # Move npcs off stage right
    # With the 'ease' transition for both in the block
    show you normal at offright
    show dinoPres normal at offright
    with ease
    
    # Change background
    scene bg nightBG with fade
    
    # Put 2 npcs at left
    # With "None", otherwise it will get lumped with the next two 'show's
    show you normal at offleft
    show dinoPres normal at offleft
    with None
    
    # Move npcs back onto screen
    show you normal at left
    show dinoPres normal at right
    with ease
    
    #
    the_npc "This officially ends the template file."
    show you normal at center
    show dinoPres normal at offright
    with ease
    hide dinoPres
    you "(That was helpful!)"
    
    # Normally you would do something here but in this case, we won't
    # $TheNPC.doRelationship()