# The main game loop. Contains both the pre- and post- planning parts

label gameLoopStart:
    
    # Administrative stuff regarding the game state
    $ myPlanner.incrementDay()
    
    # For future implementation
    # TODO: include day # milestones to use this block of code
    python :
        milestoneLabel = "mile_day%s" % (myPlanner.getDay())
        if renpy.has_label(milestoneLabel):
            renpy.jump(milestoneLabel)
        
    # If it's election time, you can go to the final day
    if myPlanner.isFinalDay() :
        jump endgame
    $ activitiesDone = 0
    
    # Choice of how the player wakes up
    $ from random import *
    $ randomChoice = choice(range(3))
    
    # Start of the day banter
    scene bg wakeupBG with fade
    
    $ _day = myPlanner.getDay()
    
    show you tired at left
    if randomChoice == 0: 
        you "*YAAAAAAWN*"
    show planner happy at offright
    show planner happy at right with ease
    if _day < 3:
        planner "Good morning!"
    planner "Are you ready for day %(_day)s of your campaign?"

    $ randomChoice = choice(range(7))
    if randomChoice == 0:    
        show you normal at left
        "You woke up a little later than you intended to after a restless night..."
        you "I'll certainly try my best."
    elif randomChoice == 1:
        show you sweat at left
        "You had a really interesting dream last night..."
        you "Uhh, yeah..."
    elif randomChoice == 2:
        show you confident at left
        "You had wonderful dreams of a successful campaign!"
        you "Of course!"
        you "There is no way anything could go wrong today!"
    
    show you normal
    
    $ morningLabel = "morning_day%s" % (myPlanner.getDay())       
    if renpy.has_label(morningLabel):
            $ renpy.jump(morningLabel)
    else :
        planner "Great! Now, let's plan out your day!"
        
        # Jump to Planner.rpy to actually plan the day.
        call plannerMenu                                                                                                                         
       
       
# Now that the day has been planned, actually perform said activities.
# This label is returned to after each activity is done, so it's important that
# we keep track of the time period.
label gameLoopActivities:
    # In the future, determine which NPC the activity is meant to be done with,
    # and fetch it.
    # Then tell it to do the activity.
    $ _planMap = myPlanner.getPlanMap()
    if activitiesDone == 0 : 
        $ npc = getNPC(_planMap['partnerMorning'])
        $ npc.doActivity(_planMap['planMorning'])
        
    elif activitiesDone == 1 :      
        scene bg wakeupBG with fade
        show planner normal at center
        planner "Ready for your afternoon?"
        
        $ npc = getNPC(_planMap['partnerAfternoon'])
        $ npc.doActivity(_planMap['planAfternoon'])
    
    # all activites complete, end the day and proceed to the next
    else :
        scene bg nightBG with fade
        show you happy at center
        "Today seemed like a good day."
        show you tired at center
        "Time for bed!"
        
        jump gameLoopStart
    
