# Robot Leader
# Golf Dialogue
# Creator: Alexa Keizur/Kimberly Sheely
# Last Edited: 3-28-11 by Benson
label leadRobo_golf:
    $ randomChoice = choice([0,1,2])
    
    scene bg golfBG with fade
    $name = myPlayer.getName()
    # Remember that this is the one that calls the methods...
    # but the call name corresponds to the renpy scene characters
    $RL = getNPC("leadRobo")
    # ... And this is the one that speaks
    $leadRobo = RL.getCharacter()
    
    if RL.isReversed() :
        jump leadRobo_reverseStill
        
    show leadRobo normal at offright
    show you normal at offleft
    with None

    show leadRobo normal at right
    show you normal at left
    with ease

    leadRobo "Greetings, %(name)s."
    leadRobo "I believe we are scheduled to golf."
    
    show leadRobo normal at right
    show you normal at left
    with fade
    
    if randomChoice == 0:        
        leadRobo "Adjusting for wind speed..."
        leadRobo "I made a birdie."
        show leadRobo happy at right
        leadRobo "Yay."
        show leadRobo confused at right
        
        leadRobo "Do you find golfing pleasant, %(name)s?"
        menu:
            leadRobo "Do you find golfing pleasant, %(name)s?"
            "Yes I do, it is very relaxing.":
                show leadRobo normal at right
                leadRobo "I agree, %(name)s."
                leadRobo "It gives me a little time to clear my circuits."
            "I find it a little boring...":
                show leadRobo normal at right
                leadRobo "I am sorry that you find my company boring, %(name)s."
                call changeStats("charm", -1)
                leadRobo "My people tend to enjoy this sport, %(name)s."

    elif randomChoice == 1:
        leadRobo "I seem to be winning by a large margin, %(name)s."
        show leadRobo confused at right
        
        leadRobo "Do you wish to continue this game?"
        menu:
            leadRobo "Do you wish to continue this game?"
            "Of course, we still have nine holes left!":
                show leadRobo happy at right
                leadRobo "Yay."
                show leadRobo normal at right
                leadRobo "I do enjoy this game, and I admire your persistence, %(name)s."
            "I am ready to call it here":
                leadRobo "Stopping at this point is acceptable, %(name)s."

    elif randomChoice == 2:
        
            leadRobo "The weather is quite pleasant today."
            menu:
                leadRobo "The weather is quite pleasant today."
                "It never seems to rain here.":
                    show leadRobo sad at right
                    leadRobo "In my country, the outdoor courses are nearly always flooded, %(name)s."
                    show leadRobo normal at right
                    leadRobo "It is a tragedy."
                "How much do robots need to worry about rain?":
                    leadRobo "Most of us are partially waterproof, but we can be damaged if we are submerged, %(name)s."
                    "You learned something about the Robots!"
                    call changeStats("intelligence", 1)
                    
    show you normal at left with fade
    show leadRobo normal at right
    leadRobo "I assume you did not call me here to simply have fun, %(name)s."
    leadRobo "I realize that we must speak of the future of our countries."
    $RL.doRelationship()
    
          
