#!/bin/bash


for f in */icon_large.png; do
    echo "convert $f to 48x48..."
    convert -gravity Center \
	-filter Triangle \
	$f \
	-resize 48x48 \
	-background transparent \
	-extent 48x48 \
	${f%_large.png}.png
done

for f in */display_large.png; do
    echo "convert $f to 64x64..."
    convert -gravity Center \
	-filter Triangle \
	$f \
	-resize 64x64 \
	-background transparent \
	-extent 64x64 \
	${f%_large.png}.png
done

