/*
 * Decompiled with CFR 0.152.
 */
package hectare;

import hectare.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundSystem
implements Runnable {
    private static final String SOUND_PATH = "/sounds/";
    private static final String CLICK_SOUND = "click.wav";
    private static final String BACKGROUND_MUSIC_PATH = "/music/";
    private static final String INDEX_FILENAME = "index.txt";
    private static final long MUSIC_UPDATE_TIME = 50L;
    private static final float MUSIC_GAIN = -0.0f;
    private static final int GAIN_STEPS = 10;
    private static final float GAIN_STEP_SIZE = 2.0f;
    public static boolean SOUND_AVAILABLE = true;
    private static SoundSystem INSTANCE;
    private byte[] songBuffer;
    private int songIndex;
    private int songDataEnd;
    private long timeSinceUpdate;
    private List<String> musicFilenames;
    private Map<String, Clip> clipCache;
    private int nextTrack;
    private SourceDataLine music;
    private AudioInputStream song;
    private Thread musicPlayer;
    private volatile boolean musicOn;

    public static SoundSystem getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SoundSystem();
        }
        return INSTANCE;
    }

    public static void reset() {
        if (INSTANCE != null) {
            SoundSystem.INSTANCE.musicOn = false;
            SoundSystem.INSTANCE.musicPlayer.interrupt();
            try {
                SoundSystem.INSTANCE.musicPlayer.join();
            }
            catch (InterruptedException e) {
                Debug.write(SoundSystem.class, "Interrupted while joining");
                e.printStackTrace();
            }
            if (SoundSystem.INSTANCE.song != null) {
                try {
                    SoundSystem.INSTANCE.song.close();
                }
                catch (IOException e) {
                    Debug.write(SoundSystem.class, "Could not close song");
                    e.printStackTrace();
                }
            }
            if (SoundSystem.INSTANCE.music != null) {
                SoundSystem.INSTANCE.music.close();
            }
            INSTANCE = null;
        }
    }

    private SoundSystem() {
        Debug.write(this, "Initializing sound system");
        String filename = "/music/index.txt";
        URL indexURL = this.getClass().getResource(filename);
        try {
            if (indexURL == null) {
                throw new IOException("Index not found at " + filename);
            }
            InputStream is = indexURL.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            this.musicFilenames = new ArrayList<String>();
            String line = br.readLine();
            while (line != null) {
                this.musicFilenames.add(line);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            Debug.write(this, "Could not load index");
            e.printStackTrace();
        }
        this.clipCache = new HashMap<String, Clip>();
        String filename1 = BACKGROUND_MUSIC_PATH + this.musicFilenames.get(0);
        try {
            URL soundURL = this.getClass().getResource(filename1);
            if (soundURL == null) {
                throw new IOException("Sound not found!");
            }
            InputStream is = soundURL.openStream();
            this.song = AudioSystem.getAudioInputStream(is);
            DataLine.Info desiredLine = new DataLine.Info(SourceDataLine.class, this.song.getFormat());
            this.music = (SourceDataLine)AudioSystem.getLine(desiredLine);
            this.music.open();
        }
        catch (IOException e) {
            SOUND_AVAILABLE = false;
            Debug.write(this, "Sound file not found");
            e.printStackTrace();
            return;
        }
        catch (UnsupportedAudioFileException e) {
            SOUND_AVAILABLE = false;
            Debug.write(this, "Audio file format not supported");
            e.printStackTrace();
            return;
        }
        catch (LineUnavailableException e) {
            SOUND_AVAILABLE = false;
            Debug.write(this, "Audio playback not possible, no playback liines found");
            e.printStackTrace();
            return;
        }
        catch (IllegalArgumentException e) {
            SOUND_AVAILABLE = false;
            Debug.write(this, "No line available, but java threw an IllegalArgumentException instead");
            e.printStackTrace();
            return;
        }
        SOUND_AVAILABLE = true;
    }

    public void startMusic() {
        if (SOUND_AVAILABLE) {
            this.nextTrack = 0;
            assert (this.musicPlayer == null);
            this.playNextMusic();
            this.musicPlayer = new Thread(this);
            this.musicPlayer.setDaemon(true);
            this.musicPlayer.start();
        }
    }

    private void playNextMusic() {
        if (this.musicFilenames != null && this.musicFilenames.size() > 0 || SOUND_AVAILABLE) {
            Debug.write(this, "Changing song");
            String filename = BACKGROUND_MUSIC_PATH + this.musicFilenames.get(this.nextTrack);
            if (this.musicFilenames.size() > 1) {
                this.nextTrack = Math.max(1, (this.nextTrack + 1) % this.musicFilenames.size());
            }
            try {
                Debug.write(this, "Loading " + filename);
                URL soundURL = this.getClass().getResource(filename);
                if (soundURL == null) {
                    throw new IOException("Sound not found!");
                }
                InputStream is = soundURL.openStream();
                this.song = AudioSystem.getAudioInputStream(is);
                this.songBuffer = new byte[0];
                this.songIndex = 0;
                this.songDataEnd = 0;
                DataLine.Info desiredLine = new DataLine.Info(SourceDataLine.class, this.song.getFormat());
                this.music = (SourceDataLine)AudioSystem.getLine(desiredLine);
                this.music.open();
                this.music.start();
                ((FloatControl)this.music.getControl(FloatControl.Type.MASTER_GAIN)).setValue(-0.0f);
            }
            catch (IOException e) {
                Debug.write(this, "Could not load " + filename);
                e.printStackTrace();
            }
            catch (UnsupportedAudioFileException e) {
                Debug.write(this, "Not a good file: " + filename);
                e.printStackTrace();
            }
            catch (LineUnavailableException e) {
                Debug.write(this, "No lines!");
                e.printStackTrace();
            }
        } else {
            Debug.write(this, "No music");
        }
    }

    @Override
    public void run() {
        long lastTime = System.currentTimeMillis();
        while (this.musicOn) {
            long now = System.currentTimeMillis();
            long elapsed = now - lastTime;
            this.tick(elapsed);
            try {
                if (elapsed < 50L) {
                    Thread.sleep(50L - elapsed);
                }
            }
            catch (InterruptedException e) {
                Debug.write(this, "Sleep interrupted.");
                Debug.write(this, e.getMessage());
            }
            lastTime = now;
        }
        Debug.write(this, "Music stopping");
        try {
            this.song.close();
        }
        catch (IOException e) {
            Debug.write(this, "Error closing file");
            e.printStackTrace();
        }
        this.music.drain();
        this.music.close();
    }

    private void tick(long elapsed) {
        this.timeSinceUpdate += elapsed;
        if (this.timeSinceUpdate < 50L) {
            return;
        }
        this.timeSinceUpdate = 0L;
        try {
            if (this.song != null && this.song.available() > 0) {
                int unplayed = this.songDataEnd - this.songIndex;
                int newData = this.song.available();
                if (this.songDataEnd + newData > this.songBuffer.length) {
                    Debug.write(this, "Need a new buffer (" + (this.songDataEnd + newData) + " > " + this.songBuffer.length + ")");
                    byte[] newBuffer = new byte[unplayed + newData];
                    int i = 0;
                    while (i < unplayed) {
                        newBuffer[i] = this.songBuffer[i + this.songIndex];
                        ++i;
                    }
                    this.songBuffer = newBuffer;
                    this.songIndex = 0;
                    this.songDataEnd = unplayed;
                }
                int bytesRead = this.song.read(this.songBuffer, this.songDataEnd, newData);
                this.songDataEnd += bytesRead;
            }
            int frameSize = this.music.getFormat().getFrameSize();
            int numFrames = Math.min(this.music.available(), this.songDataEnd - this.songIndex) / frameSize;
            int toWrite = frameSize * numFrames;
            this.music.write(this.songBuffer, this.songIndex, toWrite);
            if (this.songIndex == this.songBuffer.length) {
                Debug.write(this, "Song over");
                this.song.close();
                this.music.drain();
                this.music.close();
                this.playNextMusic();
            } else {
                this.songIndex += toWrite;
            }
        }
        catch (IOException e) {
            Debug.write(this, "Could not read music");
            e.printStackTrace();
        }
    }

    public void playSound(String filename) {
    }

    public void click() {
        this.playSound(CLICK_SOUND);
    }

    public void stopMusic() {
        if (this.music != null) {
            int i = 0;
            while (i < 10) {
                ((FloatControl)this.music.getControl(FloatControl.Type.MASTER_GAIN)).setValue(-2.0f * (float)i);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Debug.write(this, "Interrupted while decreasing volume");
                    e.printStackTrace();
                }
                ++i;
            }
        }
        this.musicOn = false;
        if (this.musicPlayer != null) {
            this.musicPlayer.interrupt();
        }
    }
}

