/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Tool;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.World;

public class CloudTool
extends Tool {
    private static final long serialVersionUID = 1L;
    private static final double REQUIRED_SCORE = 13000.0;
    private boolean hasUsed = false;

    @Override
    public boolean apply(Coordinates location, World world) {
        if (!this.hasUsed) {
            this.hasUsed = true;
        }
        world.addCloud(location, 1.0);
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Cloud";
    }

    @Override
    public boolean isUsed() {
        return this.hasUsed;
    }

    @Override
    public String getSuccessSound() {
        return "cloudmade.wav";
    }

    @Override
    public String getMouseOverText() {
        if (this.isEnabled()) {
            return "Create a cloud at the desired location.";
        }
        return "Unlocked at score " + Integer.toString(13000);
    }

    @Override
    public void tryUnlock(GameState state) {
        this.unlockByProsperity(13000.0, state);
    }

    @Override
    public String getIcon() {
        return "tool_cloud.png";
    }

    @Override
    public void setUsed(boolean setter) {
        this.hasUsed = setter;
    }
}

