/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Tool;
import hectare.model.Coordinates;
import hectare.model.Entity;
import hectare.model.ForestEntity;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.World;
import java.io.Serializable;

public class ForestTool
extends Tool
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double REQUIRED_SCORE = 16000.0;
    private static final double WATER_NEEDED = 0.2;
    private boolean hasUsed = false;

    @Override
    public boolean canApply(Coordinates location, World world) {
        Tile target = world.getTile(location);
        Entity entity = target.getEntity();
        return entity == null && target.getGroundwater() > 0.2 || entity instanceof ForestEntity;
    }

    @Override
    public boolean apply(Coordinates location, World world) {
        Tile target;
        if (!this.hasUsed) {
            this.hasUsed = true;
        }
        if ((target = world.getTile(location)).getEntity() == null && target.getGroundwater() > 0.2) {
            target.setEntity(new ForestEntity());
            return true;
        }
        if (target.getEntity() instanceof ForestEntity) {
            target.setEntity(null);
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayName() {
        return "Forest";
    }

    @Override
    public boolean isUsed() {
        return this.hasUsed;
    }

    @Override
    public String getSuccessSound() {
        return "forest.wav";
    }

    @Override
    public String getIcon() {
        return "tool_forest.png";
    }

    @Override
    public String getMouseOverText() {
        if (this.isEnabled()) {
            return "Create forests that create nutrients to help crops grow and retain water.";
        }
        return "Unlocked at score " + Integer.toString(16000);
    }

    @Override
    public void tryUnlock(GameState state) {
        this.unlockByProsperity(16000.0, state);
    }

    @Override
    public void setUsed(boolean setter) {
        this.hasUsed = setter;
    }
}

