/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Controller;
import hectare.model.Coordinates;
import hectare.model.Entity;
import hectare.model.ForestEntity;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.WaterEntity;
import hectare.model.World;

public class GroundwaterController
implements Controller {
    private static final double EVAP_FACTOR = 0.003;
    private static final double FOREST_EVAP_FACTOR = 0.001;
    private static final double EVAP_TEMP_CHANGE = 12.0;
    private static final double MAX_TEMP_CHANGE = 0.2;
    private static final double GROUNDWATER_DECAY = 0.007;
    private static final double FOREST_GROUNDWATER_DECAY = 0.001;
    private static final double GROUNDWATER_WATER = Tile.getMaxWater();
    private static final double SUN_EVAPORATE_BASE = 4.0;
    private static final double SUN_NORMAL_EVAPORATION = 1.0;
    private static final double WATER_FOREST_NEED = 0.15;
    private static final int[][] DIRECTION_VH;
    private static final int[][] DIRECTION_DI;
    private static final double DIFFUSION_WEIGHT_VH = 2.0;
    private static final double DIFFUSION_WEIGHT_DI = 1.0;
    private static final double GROUNDWATER_DIFFUSION_RATE = 0.05;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[0] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = -1;
        nArrayArray[3] = nArray4;
        DIRECTION_VH = nArrayArray;
        DIRECTION_DI = new int[][]{{1, 1}, {-1, 1}, {-1, -1}, {1, -1}};
    }

    @Override
    public void step(GameState state) {
        World theWorld = state.getWorld();
        int i = 0;
        while (i < theWorld.getWidth()) {
            int j = 0;
            while (j < theWorld.getHeight()) {
                Coordinates here = new Coordinates(i, j);
                Tile target = theWorld.getTile(here);
                this.diffuse(theWorld, here);
                this.sinkSource(target);
                this.evaporate(target);
                ++j;
            }
            ++i;
        }
    }

    private void diffuse(World world, Coordinates here) {
        Coordinates nearbyCoordinate;
        int x = here.getX();
        int y = here.getY();
        Tile target = world.getTile(here);
        double nearbyGroundwater = 0.0;
        int dir = 0;
        while (dir < 4) {
            nearbyCoordinate = new Coordinates(x + DIRECTION_VH[dir][0], y + DIRECTION_VH[dir][1]);
            nearbyGroundwater += 2.0 * world.getTile(nearbyCoordinate).getGroundwater();
            ++dir;
        }
        dir = 0;
        while (dir < 4) {
            nearbyCoordinate = new Coordinates(x + DIRECTION_DI[dir][0], y + DIRECTION_DI[dir][1]);
            nearbyGroundwater += 1.0 * world.getTile(nearbyCoordinate).getGroundwater();
            ++dir;
        }
        double newGroundWater = 0.95 * target.getGroundwater() + 0.05 * (nearbyGroundwater /= 12.0);
        target.setGroundwater(newGroundWater);
    }

    private void evaporate(Tile tile) {
        Entity entity;
        double toEvaporate = tile.getEntity() != null && tile.getEntity() instanceof ForestEntity ? tile.getGroundwater() * 0.001 * Math.pow(4.0, tile.getSun() - 1.0) : tile.getGroundwater() * 0.003 * Math.pow(4.0, tile.getSun() - 1.0);
        if (toEvaporate > tile.getGroundwater()) {
            toEvaporate = tile.getGroundwater();
        }
        tile.setGroundwater(tile.getGroundwater() - toEvaporate);
        tile.setHumidity(tile.getHumidity() + toEvaporate);
        double newTemperature = tile.getTemperature() - Math.min(toEvaporate * 12.0, 0.2);
        if (newTemperature < 0.0) {
            newTemperature = 0.0;
        }
        tile.setTemperature(newTemperature);
        if (tile.getGroundwater() < 0.15 && (entity = tile.getEntity()) != null && entity instanceof ForestEntity) {
            tile.setEntity(null);
        }
    }

    private void sinkSource(Tile tile) {
        Entity entity = tile.getEntity();
        if (entity != null && entity instanceof WaterEntity) {
            tile.setGroundwater(GROUNDWATER_WATER);
        } else if (entity != null && entity instanceof ForestEntity) {
            tile.setGroundwater(tile.getGroundwater() * 0.999);
        } else {
            tile.setGroundwater(tile.getGroundwater() * 0.993);
        }
    }
}

