/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Controller;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.Vector;
import hectare.model.World;

public class HumidityController
implements Controller {
    private static final double HUMIDITY_MOVE_FACTOR = 0.5;
    private static final double CLOUD_THRESHOLD = 1.0;
    private static final double CLOUD_PORTION = 0.5;
    private double[][] freeHumidity;

    @Override
    public void step(GameState state) {
        Coordinates here;
        int j;
        World theWorld = state.getWorld();
        this.freeHumidity = new double[theWorld.getWidth()][theWorld.getHeight()];
        int i = 0;
        while (i < theWorld.getWidth()) {
            j = 0;
            while (j < theWorld.getHeight()) {
                here = new Coordinates(i, j);
                Tile tile = theWorld.getTile(here);
                if (tile.getHumidity() >= 1.0) {
                    double toCloud = tile.getHumidity() * 0.5;
                    tile.setHumidity(tile.getHumidity() - toCloud);
                    theWorld.addCloud(here, toCloud);
                }
                this.freeHumidity[i][j] = tile.getHumidity() * 0.5;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < theWorld.getWidth()) {
            j = 0;
            while (j < theWorld.getHeight()) {
                here = new Coordinates(i, j);
                Tile source = theWorld.getTile(here);
                Vector wind = source.getWind();
                Coordinates there = new Coordinates(i + wind.getXOffset(), j + wind.getYOffset());
                if (!here.equals(there)) {
                    Tile destination = theWorld.getTile(there);
                    source.setHumidity(source.getHumidity() - this.freeHumidity[i][j]);
                    destination.setHumidity(destination.getHumidity() + this.freeHumidity[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }
}

