/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Tool;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.World;
import java.io.Serializable;

public class NutrientTool
extends Tool
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double REQUIRED_SCORE = 5000.0;
    private static final double NUTRIENT_TOOL_INCREASE = 0.1;
    private static final int NUTRIENT_TOOL_RADIUS = 5;
    private boolean hasUsed = false;

    @Override
    public boolean apply(Coordinates location, World world) {
        if (!this.hasUsed) {
            this.hasUsed = true;
        }
        int i = -5;
        while (i <= 5) {
            int j = -5;
            while (j <= 5) {
                double distance = Math.sqrt(i * i + j * j);
                if (!(distance > 5.0)) {
                    Coordinates here = new Coordinates(location.getX() + i, location.getY() + j);
                    double increment = 0.02 * (5.0 - distance);
                    Tile tile = world.getTile(here);
                    double newNutrient = tile.getNutrient() + increment;
                    if (newNutrient > Tile.getMaxNutrient()) {
                        newNutrient = Tile.getMaxNutrient();
                    }
                    tile.setNutrient(newNutrient);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Nutrient";
    }

    @Override
    public boolean isUsed() {
        return this.hasUsed;
    }

    @Override
    public String getSuccessSound() {
        return "nutrients.wav";
    }

    @Override
    public String getMouseOverText() {
        if (this.isEnabled()) {
            return "Infuse the soil with nutrients to help crops grow.";
        }
        return "Unlocked at score " + Integer.toString(5000);
    }

    @Override
    public void tryUnlock(GameState state) {
        this.unlockByProsperity(5000.0, state);
    }

    @Override
    public String getIcon() {
        return "tool_nutrients.png";
    }

    @Override
    public void setUsed(boolean setter) {
        this.hasUsed = setter;
    }
}

