/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Controller;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.World;

public class TemperatureController
implements Controller {
    private static final double TROPICAL_SUN = 1.2;
    private static final double WORLD_SUN_DIFF = 0.9;
    private static final double SUN_BY_TOOL_DECAY = 0.02;
    private static final double TEMP_RESTORE = 0.1;
    private static final double MAX_TEMPERATURE = 2.0;
    private static final int[][] DIRECTION_VH;
    private static final int[][] DIRECTION_DI;
    private static final double DIFFUSION_WEIGHT_VH = 2.0;
    private static final double DIFFUSION_WEIGHT_DI = 1.0;
    private static final double TEMPERATURE_DIFFUSION_RATE = 0.3;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[0] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = -1;
        nArrayArray[3] = nArray4;
        DIRECTION_VH = nArrayArray;
        DIRECTION_DI = new int[][]{{1, 1}, {-1, 1}, {-1, -1}, {1, -1}};
    }

    @Override
    public void step(GameState state) {
        World theWorld = state.getWorld();
        int i = 0;
        while (i < theWorld.getWidth()) {
            int j = 0;
            while (j < theWorld.getHeight()) {
                Coordinates here = new Coordinates(i, j);
                Tile target = theWorld.getTile(here);
                this.diffuse(theWorld, here);
                double defaultSun = this.getDefaultSun(here);
                double newSun = defaultSun + target.getSunByTool();
                double newSunByTool = target.getSunByTool() * 0.98;
                double newTemperature = 0.9 * target.getTemperature() + 0.1 * newSun;
                if (newTemperature > 2.0) {
                    newTemperature = 2.0;
                }
                target.setSun(newSun);
                target.setSunByTool(newSunByTool);
                target.setTemperature(newTemperature);
                ++j;
            }
            ++i;
        }
    }

    private void diffuse(World world, Coordinates here) {
        Coordinates nearbyCoordinate;
        int x = here.getX();
        int y = here.getY();
        Tile target = world.getTile(here);
        double nearbyTemperature = 0.0;
        int dir = 0;
        while (dir < 4) {
            nearbyCoordinate = new Coordinates(x + DIRECTION_VH[dir][0], y + DIRECTION_VH[dir][1]);
            nearbyTemperature += 2.0 * world.getTile(nearbyCoordinate).getTemperature();
            ++dir;
        }
        dir = 0;
        while (dir < 4) {
            nearbyCoordinate = new Coordinates(x + DIRECTION_DI[dir][0], y + DIRECTION_DI[dir][1]);
            nearbyTemperature += 1.0 * world.getTile(nearbyCoordinate).getTemperature();
            ++dir;
        }
        double newTemperature = 0.7 * target.getTemperature() + 0.3 * (nearbyTemperature /= 12.0);
        target.setTemperature(newTemperature);
    }

    private double getDefaultSun(Coordinates here) {
        return 1.2 - 0.9 * (double)Math.abs(here.getX() - here.getY()) / 100.0;
    }
}

