/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.SoundSystem;
import hectare.controller.Controller;
import hectare.model.Coordinates;
import hectare.model.Entity;
import hectare.model.FieldEntity;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.TownEntity;
import hectare.model.World;
import hectare.view.Notification;
import hectare.view.NotificationSystem;

public class TownController
implements Controller {
    private static final double PROSPERITY_INCREASE_RATE = 0.005;
    private static final double PROSPERITY_DECREASE_FACTOR = 0.06;
    private static final double MIN_PROSPERITY = 0.04;
    private static final double MAX_INITIAL_PRODUCTIVITY = 0.01;
    private static final double NEW_FIELD_THRESHOLD = 0.7;
    private static final double PRODUCTIVITY_INCREASE_RATE = 0.2;
    private static final double PRODUCTIVITY_DECREASE_RATE = 0.1;
    private static final double MIN_PRODUCTIVITY = 0.05;
    private static final int[][] FIELD_POSITIONS;
    private static final double FIRST_TOWN_UNLOCK_PERCENTAGE = 0.6;
    private static final double LAST_TOWN_UNLOCK_PERCENTAGE = 0.9;

    static {
        int[][] nArrayArray = new int[24][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[0] = -1;
        nArrayArray[3] = nArray4;
        nArrayArray[4] = new int[]{-1, 1};
        nArrayArray[5] = new int[]{1, 1};
        nArrayArray[6] = new int[]{1, -1};
        nArrayArray[7] = new int[]{-1, -1};
        int[] nArray5 = new int[2];
        nArray5[1] = 2;
        nArrayArray[8] = nArray5;
        int[] nArray6 = new int[2];
        nArray6[0] = 2;
        nArrayArray[9] = nArray6;
        int[] nArray7 = new int[2];
        nArray7[1] = -2;
        nArrayArray[10] = nArray7;
        int[] nArray8 = new int[2];
        nArray8[0] = -2;
        nArrayArray[11] = nArray8;
        nArrayArray[12] = new int[]{-1, 2};
        nArrayArray[13] = new int[]{1, 2};
        nArrayArray[14] = new int[]{2, 1};
        nArrayArray[15] = new int[]{2, -1};
        nArrayArray[16] = new int[]{1, -2};
        nArrayArray[17] = new int[]{-1, -2};
        nArrayArray[18] = new int[]{-2, -1};
        nArrayArray[19] = new int[]{-2, 1};
        nArrayArray[20] = new int[]{-2, 2};
        nArrayArray[21] = new int[]{2, 2};
        nArrayArray[22] = new int[]{2, -2};
        nArrayArray[23] = new int[]{-2, -2};
        FIELD_POSITIONS = nArrayArray;
    }

    @Override
    public void step(GameState state) {
        World theWorld = state.getWorld();
        this.tryUnlockNewTowns(theWorld);
        int townUnlocked = theWorld.getTownsUnlocked();
        int i = 0;
        while (i < theWorld.getTownCount()) {
            TownEntity town = theWorld.getTown(i);
            Coordinates here = theWorld.getTownPosition(i);
            if (!town.isActive()) {
                this.tryConstructNewTown(town, here);
            } else {
                this.updateFieldAroundTown(theWorld, town, here);
            }
            ++i;
        }
        this.updateProsperity(theWorld);
        i = 0;
        while (i < townUnlocked) {
            Coordinates here = theWorld.getTownPosition(i);
            TownEntity town = theWorld.getTown(i);
            if (town.isActive() && town.getProsperity() < 0.04) {
                this.destroyTownAndFields(theWorld, town, here);
            }
            ++i;
        }
    }

    public double prosperityToProceed(World theWorld, int townNum) {
        if (townNum >= theWorld.getTownCount()) {
            return Double.POSITIVE_INFINITY;
        }
        return (0.6 + 0.30000000000000004 * (double)townNum / (double)theWorld.getTownCount()) * (double)townNum;
    }

    private void tryUnlockNewTowns(World theWorld) {
        int townUnlocked = theWorld.getTownsUnlocked();
        while (townUnlocked == 0) {
            theWorld.unlockTown();
            ++townUnlocked;
        }
        theWorld.setNextTownProsperity(this.prosperityToProceed(theWorld, townUnlocked));
    }

    private void tryConstructNewTown(TownEntity town, Coordinates here) {
        if (town.isReady()) {
            town.construct();
            SoundSystem.getInstance().playSound("townconstructed.wav");
            Notification n = new Notification("You have a new town!", here, 10.0);
            NotificationSystem.getInstance().postNotification(n, "MINIMAP");
        } else {
            town.decreaseWait();
        }
    }

    private void updateFieldAroundTown(World theWorld, TownEntity town, Coordinates here) {
        double prosperity = town.getProsperity() * (double)FIELD_POSITIONS.length;
        int i = 0;
        while (i < FIELD_POSITIONS.length) {
            FieldEntity field;
            Coordinates there = new Coordinates(here.getX() + FIELD_POSITIONS[i][0], here.getY() + FIELD_POSITIONS[i][1]);
            Tile target = theWorld.getTile(there);
            Entity entity = target.getEntity();
            if (entity instanceof FieldEntity) {
                field = (FieldEntity)theWorld.getTile(there).getEntity();
                this.updateFieldProductivity(field, target);
            } else if (entity == null && prosperity >= 0.7 * (double)i) {
                this.createField(theWorld, there);
            }
            entity = target.getEntity();
            if (entity instanceof FieldEntity) {
                field = (FieldEntity)theWorld.getTile(there).getEntity();
                field.setSunLevel(target.getSun());
                field.setWaterLevel(target.getGroundwater());
            }
            ++i;
        }
    }

    private void updateFieldProductivity(FieldEntity field, Tile target) {
        double currentProductivity = target.getCurrentProductivity();
        double productivity = field.getProductivity();
        double newProductivity = productivity < currentProductivity ? productivity + Math.min(0.2, currentProductivity - productivity) : productivity - Math.min(0.1, productivity - currentProductivity);
        field.setProductivity(newProductivity);
        if (productivity < 0.05 && currentProductivity < 0.05) {
            target.setEntity(null);
        }
    }

    private void createField(World theWorld, Coordinates there) {
        double currentProductivity = theWorld.getTile(there).getCurrentProductivity();
        if (currentProductivity >= 0.05) {
            theWorld.getTile(there).setEntity(new FieldEntity());
            FieldEntity field = (FieldEntity)theWorld.getTile(there).getEntity();
            field.setProductivity(Math.min(0.01, currentProductivity));
        }
    }

    private void updateProsperity(World theWorld) {
        double totalProsperity = 0.0;
        int i = 0;
        while (i < theWorld.getTownCount()) {
            Coordinates here = theWorld.getTownPosition(i);
            TownEntity town = theWorld.getTown(i);
            if (town.isActive()) {
                this.updateTownProsperity(theWorld, town, here);
                totalProsperity += town.getProsperity();
            }
            ++i;
        }
        theWorld.setTotalProsperity(totalProsperity);
    }

    private void updateTownProsperity(World theWorld, TownEntity town, Coordinates here) {
        double targetProsperity;
        double totalProductivity = 0.0;
        int j = 0;
        while (j < FIELD_POSITIONS.length) {
            Coordinates there = new Coordinates(here.getX() + FIELD_POSITIONS[j][0], here.getY() + FIELD_POSITIONS[j][1]);
            if (theWorld.getTile(there).getEntity() instanceof FieldEntity) {
                totalProductivity += ((FieldEntity)theWorld.getTile(there).getEntity()).getProductivity();
            }
            ++j;
        }
        double prosperity = town.getProsperity();
        double newProsperity = prosperity < (targetProsperity = totalProductivity / (double)FIELD_POSITIONS.length) ? prosperity + Math.min(0.005, targetProsperity - prosperity) : Math.max(prosperity * 0.94, targetProsperity);
        town.setProsperity(newProsperity);
    }

    private void destroyTownAndFields(World theWorld, TownEntity town, Coordinates here) {
        town.destroy();
        SoundSystem.getInstance().playSound("towndestroyed.wav");
        Notification n = new Notification("You have lost a town!", here, 10.0);
        NotificationSystem.getInstance().postNotification(n, "MINIMAP");
        int j = 0;
        while (j < FIELD_POSITIONS.length) {
            Coordinates there = new Coordinates(here.getX() + FIELD_POSITIONS[j][0], here.getY() + FIELD_POSITIONS[j][1]);
            if (theWorld.getTile(there).getEntity() instanceof FieldEntity) {
                theWorld.getTile(there).setEntity(null);
            }
            ++j;
        }
    }
}

