/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Controller;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.MountainEntity;
import hectare.model.Tile;
import hectare.model.Vector;
import hectare.model.World;
import java.util.Random;

public class WindController
implements Controller {
    private static final double WIND_RANDOMNESS = 1.0;
    private static final double WIND_INFLUENCE = 1.0;
    private static final double WIND_BIAS_X = 0.07;
    private static final double WIND_BIAS_Y = 0.07;
    private static final double MOUNTAIN_WIND = 0.09;
    private static final double WIND_BY_TEMP = 0.8;
    private static final double WIND_BY_TOOL_DECAY = 0.3;
    private static final int[][] DIRECTION_VH;
    private static final Random RND;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[0] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = -1;
        nArrayArray[3] = nArray4;
        DIRECTION_VH = nArrayArray;
        RND = new Random();
    }

    @Override
    public void step(GameState state) {
        World theWorld = state.getWorld();
        this.createWindFromMountains(theWorld);
        this.calculateWorldBaseWind(theWorld);
        this.globalWindFlow(theWorld);
    }

    private void createWindFromMountains(World theWorld) {
        int i = 0;
        while (i < theWorld.getWidth()) {
            int j = 0;
            while (j < theWorld.getHeight()) {
                Coordinates here = new Coordinates(i, j);
                if (theWorld.getTile(here).getEntity() instanceof MountainEntity) {
                    this.createWindFromMountainTile(theWorld, here);
                }
                ++j;
            }
            ++i;
        }
    }

    private void createWindFromMountainTile(World theWorld, Coordinates here) {
        int k = -1;
        while (k <= 1) {
            int l = -1;
            while (l <= 1) {
                Coordinates radial = new Coordinates(here.getX() + k, here.getY() + l);
                if (!radial.equals(here)) {
                    Tile there = theWorld.getTile(radial);
                    Vector mountainWind = new Vector(0.09 * (double)k, 0.09 * (double)l);
                    there.addWind(mountainWind);
                }
                ++l;
            }
            ++k;
        }
    }

    private void calculateWorldBaseWind(World theWorld) {
        int i = 0;
        while (i < theWorld.getWidth()) {
            int j = 0;
            while (j < theWorld.getHeight()) {
                Coordinates here = new Coordinates(i, j);
                this.calculateBaseWind(theWorld, here);
                ++j;
            }
            ++i;
        }
    }

    private void calculateBaseWind(World theWorld, Coordinates here) {
        Tile tile = theWorld.getTile(here);
        tile.addWind(new Vector(RND).multiply(1.0));
        tile.addWind(new Vector(0.07, 0.07));
        Vector tempGradient = new Vector(0.0, 0.0);
        int dir = 0;
        while (dir < 4) {
            Coordinates there = new Coordinates(here.getX() + DIRECTION_VH[dir][0], here.getY() + DIRECTION_VH[dir][1]);
            double temperatureThere = theWorld.getTile(there).getTemperature();
            Vector directionalIncrement = new Vector(temperatureThere * (double)DIRECTION_VH[dir][0], temperatureThere * (double)DIRECTION_VH[dir][1]);
            tempGradient = tempGradient.add(directionalIncrement);
            ++dir;
        }
        tile.addWind(tempGradient.multiply(0.8));
        tile.addWind(tile.getWindByTool());
        tile.updateWind();
        tile.setWindByTool(tile.getWindByTool().multiply(0.7));
    }

    private void globalWindFlow(World theWorld) {
        int i = 0;
        while (i < theWorld.getWidth()) {
            int j = 0;
            while (j < theWorld.getHeight()) {
                Coordinates here = new Coordinates(i, j);
                Tile source = theWorld.getTile(here);
                Vector wind = source.getWind();
                Coordinates there = new Coordinates(i + wind.getXOffset(), j + wind.getYOffset());
                if (!(source.getEntity() instanceof MountainEntity) && theWorld.getTile(there).getEntity() instanceof MountainEntity) {
                    source.setWind(new Vector(0.0, 0.0));
                    there = here;
                }
                if (!here.equals(there)) {
                    Tile destination = theWorld.getTile(there);
                    this.flowWind(source, destination);
                }
                ++j;
            }
            ++i;
        }
    }

    private void flowWind(Tile source, Tile destination) {
        destination.addWind(source.getWind().multiply(1.0));
    }
}

