/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Tool;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.Vector;
import hectare.model.World;
import java.io.Serializable;

public class WindTool
extends Tool
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double REQUIRED_SCORE = 2000.0;
    private static final double WIND_TOOL_VELOCITY = 10.0;
    private static final int WIND_TOOL_RADIUS = 4;
    private static final double WIND_BY_TOOL_LIMIT = 30.0;
    private boolean hasUsed = false;

    @Override
    public boolean apply(Coordinates location, World world) {
        if (!this.hasUsed) {
            this.hasUsed = true;
        }
        int i = -4;
        while (i <= 4) {
            int j = -4;
            while (j <= 4) {
                double distance = Math.sqrt(i * i + j * j);
                if (!(distance > 4.0) && !(distance < 0.5)) {
                    Coordinates here = new Coordinates(location.getX() + i, location.getY() + j);
                    Tile tile = world.getTile(here);
                    double velocity = 2.5 * (4.0 - distance + 1.0);
                    Vector windEffect = new Vector(i, j).normalize().multiply(velocity);
                    tile.addWindByTool(windEffect);
                    Vector currentWind = tile.getWindByTool();
                    double length = currentWind.getLength();
                    if (length > 30.0) {
                        currentWind.multiply(30.0 / length);
                        tile.setWindByTool(currentWind);
                    }
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Wind";
    }

    @Override
    public boolean isUsed() {
        return this.hasUsed;
    }

    @Override
    public String getSuccessSound() {
        return "wind.wav";
    }

    @Override
    public String getIcon() {
        return "tool_wind.png";
    }

    @Override
    public String getMouseOverText() {
        if (this.isEnabled()) {
            return "Blow clouds away from a square.";
        }
        return "Unlocked at score " + Integer.toString(2000);
    }

    @Override
    public void tryUnlock(GameState state) {
        this.unlockByProsperity(2000.0, state);
    }

    @Override
    public void setUsed(boolean setter) {
        this.hasUsed = setter;
    }
}

