/*
 * Decompiled with CFR 0.152.
 */
package hectare.model;

import hectare.model.Coordinates;
import java.io.Serializable;

public class Cloud
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double RAIN_START_THRESHOLD = 1.5;
    private static final double RAIN_STOP_THRESHOLD = 0.0;
    private static final double RAIN_MIN = 0.05;
    private static final double RAIN_FACTOR = 0.1;
    private static final double EPSILON = 1.0E-4;
    private boolean raining;
    private double water;
    private Coordinates position;
    private Coordinates destination;

    public Cloud(Coordinates cloudPosition, double cloudWater) {
        this.destination = this.position = cloudPosition;
        this.water = cloudWater;
    }

    public void updateRaining() {
        if (!this.raining && this.water >= 1.5) {
            this.raining = true;
        } else if (this.raining && this.water <= 0.0) {
            this.raining = false;
        }
    }

    public double rainfall() {
        if (this.raining) {
            double toRain = Math.min(0.05 + 0.1 * this.water, this.water);
            this.water -= toRain;
            return toRain;
        }
        return 0.0;
    }

    public Coordinates getPosition() {
        return this.position;
    }

    public void setDestination(Coordinates cloudDestination) {
        this.destination = cloudDestination;
    }

    public Coordinates getDestination() {
        return this.destination;
    }

    public void snapToDestination() {
        this.position = new Coordinates(this.destination.getX(), this.destination.getY());
    }

    public void setRaining(boolean cloudRaining) {
        this.raining = cloudRaining;
    }

    public boolean isRaining() {
        return this.raining;
    }

    public double getXInterpolated(double interpolation) {
        double diff = this.destination.getLiteralX() - this.position.getLiteralX();
        return (double)this.position.getLiteralX() + diff * interpolation;
    }

    public double getYInterpolated(double interpolation) {
        double diff = this.destination.getLiteralY() - this.position.getLiteralY();
        return (double)this.position.getLiteralY() + diff * interpolation;
    }

    public void eat(Cloud other) {
        this.water += other.water;
        other.water = 0.0;
        this.raining = this.raining || other.raining;
    }

    public boolean isEmpty() {
        return this.water < 1.0E-4;
    }
}

