/*
 * Decompiled with CFR 0.152.
 */
package hectare.model;

import java.io.Serializable;

public class Coordinates
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int x;
    private final int y;
    private final int literalx;
    private final int literaly;
    private final boolean wrap;

    public Coordinates(int varX, int varY) {
        this.literalx = varX;
        this.literaly = varY;
        int worldSize = 100;
        varX = (varX + 2 * worldSize) % (2 * worldSize);
        varY = (varY + 2 * worldSize) % (2 * worldSize);
        if (varX >= worldSize && varY >= worldSize) {
            varX = 2 * worldSize - 1 - varX;
            varY = 2 * worldSize - 1 - varY;
        } else if (varX >= worldSize) {
            int temp = worldSize - 1 - varY;
            varY = varX - worldSize;
            varX = temp;
        } else if (varY >= worldSize) {
            int temp = worldSize - 1 - varX;
            varX = varY - worldSize;
            varY = temp;
        }
        this.x = varX;
        this.y = varY;
        this.wrap = this.x != this.literalx || this.y != this.literaly;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getLiteralX() {
        return this.literalx;
    }

    public int getLiteralY() {
        return this.literaly;
    }

    public boolean isWrapped() {
        return this.wrap;
    }

    public boolean equals(Object o) {
        if (o instanceof Coordinates) {
            Coordinates other = (Coordinates)o;
            return this.x == other.x && this.y == other.y;
        }
        return false;
    }

    public Coordinates getTopNeighbor() {
        return new Coordinates(this.x, this.y + 1);
    }

    public Coordinates getRightNeighbor() {
        return new Coordinates(this.x + 1, this.y);
    }

    public Coordinates getBottomNeighbor() {
        return new Coordinates(this.x, this.y - 1);
    }

    public Coordinates getLeftNeighbor() {
        return new Coordinates(this.x - 1, this.y);
    }

    public int hashCode() {
        return this.x * 100 + this.y;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

