/*
 * Decompiled with CFR 0.152.
 */
package hectare.model;

import hectare.model.Entity;
import hectare.view.EntityDrawer;
import hectare.view.entitydrawers.TownDrawer;
import java.io.IOException;
import java.io.ObjectInputStream;

public class TownEntity
implements Entity {
    private static final long serialVersionUID = 1L;
    private static final double INITIAL_PROSPERITY = 0.1;
    private static final int RECONSTRUCTION_DELAY = 60;
    private static final double PROSP_TO_POP = 1000.0;
    private boolean active;
    private boolean unlocked;
    private double prosperity;
    private int reconstructionWait;
    private int difficulty;
    private transient TownDrawer drawer = new TownDrawer(this);

    public static int toPopulation(double inquiredProsperity) {
        if (inquiredProsperity == Double.POSITIVE_INFINITY) {
            return -1;
        }
        return (int)(inquiredProsperity * 1000.0);
    }

    public TownEntity(int diff) {
        this.difficulty = diff;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.drawer = new TownDrawer(this);
    }

    public int getScore() {
        return this.difficulty * TownEntity.toPopulation(this.prosperity);
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    @Override
    public EntityDrawer getDrawer() {
        return this.drawer;
    }

    public boolean isActive() {
        return this.active;
    }

    public void construct() {
        this.active = true;
        this.prosperity = 0.1;
    }

    public void destroy() {
        this.active = false;
        this.prosperity = 0.0;
        this.reconstructionWait = 60;
    }

    public double getProsperity() {
        return this.prosperity;
    }

    public void setProsperity(double newProsperity) {
        this.prosperity = newProsperity;
    }

    public boolean decreaseWait() {
        if (this.reconstructionWait > 0) {
            --this.reconstructionWait;
            return true;
        }
        return false;
    }

    public boolean isReady() {
        return this.reconstructionWait == 0 && this.unlocked;
    }

    public int getPopulation() {
        return (int)(this.prosperity * 1000.0);
    }

    public void unlock() {
        this.unlocked = true;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }
}

