/*
 * Decompiled with CFR 0.152.
 */
package hectare.model;

import java.io.Serializable;
import java.util.Random;

public class Vector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double x;
    private final double y;

    public Vector(double px, double py) {
        this.x = px;
        this.y = py;
    }

    public Vector(Random rnd) {
        double r = rnd.nextDouble();
        double theta = rnd.nextDouble() * 2.0 * Math.PI - Math.PI;
        this.x = r * Math.sin(theta);
        this.y = r * Math.cos(theta);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getXOffset() {
        return (int)Math.round(this.x);
    }

    public int getYOffset() {
        return (int)Math.round(this.y);
    }

    public Vector add(Vector other) {
        return new Vector(this.x + other.x, this.y + other.y);
    }

    public Vector multiply(double scalar) {
        return new Vector(this.x * scalar, this.y * scalar);
    }

    public double getLength() {
        return Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0));
    }

    public Vector normalize() {
        return this.multiply(1.0 / this.getLength());
    }
}

