/*
 * Decompiled with CFR 0.152.
 */
package hectare.testing;

import hectare.Debug;
import hectare.model.Coordinates;
import hectare.model.FieldEntity;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.TownEntity;
import hectare.view.MainWindow;
import hectare.view.widgets.IsoView;
import hectare.view.widgets.Minimap;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.junit.BeforeClass;
import org.junit.Test;

public class ViewBenchmark {
    private static final String MAP_FILE = "/maps/world.txt";
    private static final int INITIAL_STEPS = 100;
    private static final int NUM_TOWNS = 20;
    private static final int NUM_FIELDS = 320;
    private static final int NUM_TESTS = 1000;
    private static final int ISOVIEW_WIDTH = 1024;
    private static final int ISOVIEW_HEIGHT = 768;
    private static final int MINIMAP_WIDTH = 300;
    private static final int MINIMAP_HEIGHT = 150;
    private static GameState state;
    private static IsoView view;
    private static Minimap minimap;

    @BeforeClass
    public static void setup() {
        Tile t;
        Coordinates c;
        Debug.setEnabled(true);
        Debug.write(ViewBenchmark.class, "Setting up world...");
        state = new GameState(MAP_FILE, new MainWindow());
        Debug.setEnabled(false);
        int i = 0;
        while (i < 100) {
            state.step();
            ++i;
        }
        Debug.setEnabled(true);
        Random r = new Random(0L);
        int i2 = 0;
        while (i2 < 20) {
            c = new Coordinates(r.nextInt(100), r.nextInt(100));
            t = state.getWorld().getTile(c);
            TownEntity town = new TownEntity(2);
            town.construct();
            town.setProsperity(r.nextDouble());
            t.setEntity(town);
            ++i2;
        }
        i2 = 0;
        while (i2 < 320) {
            c = new Coordinates(r.nextInt(100), r.nextInt(100));
            t = state.getWorld().getTile(c);
            FieldEntity field = new FieldEntity();
            field.setProductivity(r.nextDouble());
            t.setEntity(field);
            ++i2;
        }
        view = new IsoView(1024, 768, state);
        minimap = new Minimap(300, 150, view);
        view.removeMouseListener(view);
        view.removeMouseMotionListener(view);
        minimap.removeMouseListener(minimap);
        minimap.removeMouseMotionListener(minimap);
    }

    private Graphics makeContext(int w, int h) {
        BufferedImage img = new BufferedImage(w, h, 1);
        return img.getGraphics();
    }

    @Test
    public void benchmarkIsoView() {
        long seed = System.currentTimeMillis();
        Debug.write(this, "IsoView benchmark (seed=" + seed + ")...");
        Random rand = new Random(seed);
        Coordinates[] positions = new Coordinates[1000];
        int i = 0;
        while (i < positions.length) {
            int x = rand.nextInt(100);
            int y = rand.nextInt(100);
            positions[i] = new Coordinates(x, y);
            ++i;
        }
        Graphics g = this.makeContext(view.getWidth(), view.getHeight());
        long start = System.currentTimeMillis();
        view.setEnabled(true);
        int i2 = 0;
        while (i2 < 1000) {
            view.centerOnPosition(positions[i2]);
            view.paint(g);
            ++i2;
        }
        long end = System.currentTimeMillis();
        double millisPerRun = (double)(end - start) / 1000.0;
        System.err.println("IsoView draw time: " + millisPerRun + "ms");
    }

    @Test
    public void benchmarkMinimap() {
        Debug.write(this, "Minimap benchmark...");
        view.centerOnPosition(new Coordinates(50, 50));
        Graphics g = this.makeContext(minimap.getWidth(), minimap.getHeight());
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 1000) {
            minimap.paint(g);
            ++i;
        }
        long end = System.currentTimeMillis();
        double millisPerRun = (double)(end - start) / 1000.0;
        System.err.println("Minimap draw time: " + millisPerRun + "ms");
    }
}

