/*
 * Decompiled with CFR 0.152.
 */
package hectare.view;

import hectare.model.Coordinates;
import hectare.model.Vector;
import hectare.model.World;
import hectare.view.IsoPoint;
import hectare.view.ScreenPoint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.Iterator;

public class CoordinateConverter {
    private static final float Z_SCALE = 1.0f;
    private final float TILE_WIDTH;
    private final float TILE_HEIGHT;
    private float viewX;
    private float viewY;

    public CoordinateConverter(int worldWidth, int worldHeight, Rectangle displayRegion) {
        this((float)displayRegion.width / (float)(worldHeight + worldWidth) * 2.0f, (float)displayRegion.height / (float)(worldHeight + worldWidth) * 2.0f);
        float yOffset = (float)worldHeight * (this.TILE_HEIGHT / 2.0f);
        this.setOrigin(displayRegion.x, (float)displayRegion.y + yOffset);
    }

    public CoordinateConverter(float tileWidth, float tileHeight) {
        if (tileWidth == 0.0f || tileHeight == 0.0f) {
            throw new IllegalArgumentException("Tile width or height cannot be zero!");
        }
        this.TILE_WIDTH = tileWidth;
        this.TILE_HEIGHT = tileHeight;
        this.viewY = 0.0f;
        this.viewX = 0.0f;
    }

    public float getTileWidth() {
        return this.TILE_WIDTH;
    }

    public float getTileHeight() {
        return this.TILE_HEIGHT;
    }

    public void setOrigin(float x, float y) {
        this.viewX = x;
        this.viewY = y;
    }

    public void moveOrigin(float dx, float dy) {
        this.viewX += dx;
        this.viewY += dy;
    }

    public IsoPoint getIsoPosition(float x, float y) {
        float returnX = (y - this.viewY) / this.TILE_HEIGHT + (x - this.viewX) / this.TILE_WIDTH;
        float returnY = (-y + this.viewY) / this.TILE_HEIGHT + (x - this.viewX) / this.TILE_WIDTH;
        return new IsoPoint(returnX, returnY, 0.0f);
    }

    public IsoPoint getBestIsoPosition(World world, float x, float y) {
        IsoPoint p = this.getIsoPosition(x, y);
        p.x = Math.max(p.x, 0.0f);
        p.y = Math.max(p.y, 0.0f);
        p.x = Math.min(p.x, (float)world.getWidth());
        p.y = Math.min(p.y, (float)world.getHeight());
        return p;
    }

    public ScreenPoint getScreenPosition(float x, float y, float z) {
        float returnX = this.viewX + this.TILE_WIDTH * x / 2.0f + this.TILE_WIDTH * y / 2.0f;
        float returnY = this.viewY - this.TILE_HEIGHT * y / 2.0f + this.TILE_HEIGHT * x / 2.0f - z * 1.0f;
        return new ScreenPoint(returnX, returnY);
    }

    public ScreenPoint getScreenPosition(IsoPoint p) {
        return this.getScreenPosition(p.x, p.y, p.z);
    }

    public ScreenPoint tileTopCorner(float x, float y) {
        return this.getScreenPosition(x, y + 1.0f, 0.0f);
    }

    public ScreenPoint tileLeftCorner(float x, float y) {
        return this.getScreenPosition(x, y, 0.0f);
    }

    public ScreenPoint tileBottomCorner(float x, float y) {
        return this.getScreenPosition(x + 1.0f, y, 0.0f);
    }

    public ScreenPoint tileRightCorner(float x, float y) {
        return this.getScreenPosition(x + 1.0f, y + 1.0f, 0.0f);
    }

    public ScreenPoint tileCenter(Coordinates c) {
        ScreenPoint p = this.tileLeftCorner(c.getX(), c.getY());
        p.setLocation(p.getX() + (double)(this.TILE_WIDTH / 2.0f), p.getY());
        return p;
    }

    public Shape mapRectToScreen(int x, int y, int width, int height) {
        Polygon p = new Polygon();
        ScreenPoint top = this.tileLeftCorner(x, y + height);
        ScreenPoint left = this.tileLeftCorner(x, y);
        ScreenPoint bottom = this.tileLeftCorner(x + width, y);
        ScreenPoint right = this.tileLeftCorner(x + width, y + height);
        p.addPoint((int)((Point2D)top).getX(), (int)((Point2D)top).getY());
        p.addPoint((int)((Point2D)left).getX(), (int)((Point2D)left).getY());
        p.addPoint((int)((Point2D)bottom).getX(), (int)((Point2D)bottom).getY());
        p.addPoint((int)((Point2D)right).getX(), (int)((Point2D)right).getY());
        return p;
    }

    public Iterator<Coordinates> getBackToFrontIterator(World world) {
        return new BackToFrontTileIterator(world);
    }

    public Iterator<Coordinates> getBackToFrontIterator(World world, Rectangle region) {
        IsoPoint ul = this.getIsoPosition(region.x, region.y);
        IsoPoint ur = this.getIsoPosition(region.x + region.width, region.y);
        IsoPoint bl = this.getIsoPosition(region.x, region.y + region.height);
        IsoPoint br = this.getIsoPosition(region.x + region.width, region.y + region.height);
        return new BackToFrontTileIterator(world, (int)ul.x, (int)bl.y, (int)Math.ceil(br.x - ul.x), (int)Math.ceil(ur.y - bl.y));
    }

    public Vector getScreenVector(Vector mapVector) {
        Vector x = new Vector(this.TILE_WIDTH, this.TILE_HEIGHT).normalize();
        Vector y = new Vector(this.TILE_WIDTH, -this.TILE_HEIGHT).normalize();
        Vector onScreenX = x.multiply(mapVector.getX());
        Vector onScreenY = y.multiply(mapVector.getY());
        return onScreenX.add(onScreenY);
    }

    private static class BackToFrontTileIterator
    implements Iterator<Coordinates> {
        private final int MAX_X;
        private final int MIN_Y;
        private final int MAX_Y;
        private int x;
        private int y;

        public BackToFrontTileIterator(World world) {
            this(world, 0, world.getHeight(), world.getWidth(), world.getHeight());
        }

        public BackToFrontTileIterator(World world, int startx, int starty, int w, int h) {
            this.x = startx;
            this.y = starty + 1;
            this.x = Math.max(this.x, 0);
            this.MIN_Y = this.y = Math.max(this.y, 0);
            this.MAX_X = Math.min(startx + w, world.getWidth());
            this.y = this.MAX_Y = Math.min(starty + h, world.getHeight());
        }

        @Override
        public boolean hasNext() {
            return this.y > this.MIN_Y || this.x < this.MAX_X;
        }

        @Override
        public Coordinates next() {
            --this.y;
            if (this.y < 0) {
                this.y = this.MAX_Y;
                ++this.x;
            }
            Coordinates toReturn = new Coordinates(this.x, this.y);
            assert (!toReturn.isWrapped());
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove tiles from the map!");
        }
    }
}

