/*
 * Decompiled with CFR 0.152.
 */
package hectare.view;

import hectare.model.Coordinates;
import hectare.model.Entity;
import hectare.view.CoordinateConverter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public abstract class EntityDrawer {
    protected void draw(Graphics2D g, Coordinates coords, CoordinateConverter converter) {
    }

    public void draw(Graphics2D g, Coordinates coords, CoordinateConverter converter, Entity top, Entity right, Entity bottom, Entity left) {
        this.draw(g, coords, converter);
    }

    public void drawUnderGrid(Graphics2D g, Coordinates coords, CoordinateConverter converter, Entity top, Entity right, Entity bottom, Entity left) {
    }

    public boolean needsRedraw() {
        return false;
    }

    public Rectangle getDrawArea(Coordinates coords, CoordinateConverter converter) {
        return converter.mapRectToScreen(coords.getX(), coords.getY(), 1, 1).getBounds();
    }

    public void drawMini(Graphics2D g, Coordinates coords, CoordinateConverter converter) {
        this.draw(g, coords, converter);
    }

    public Dimension getQuerySize() {
        return null;
    }

    public void drawQueryInfo(Graphics2D g, Rectangle region) {
    }

    public boolean drawUnderlyingTileInfo() {
        return true;
    }
}

