/*
 * Decompiled with CFR 0.152.
 */
package hectare.view;

import hectare.model.Coordinates;
import hectare.view.ScreenPoint;
import hectare.view.utilities.DrawUtilities;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class Notification {
    private final long lifetime;
    private final String text;
    private final Coordinates location;
    private boolean enabled;
    private ScreenPoint pointTo;
    private long startTime;
    private boolean inverted;

    public Notification(String text, Coordinates location, double lifetime) {
        this.text = text;
        this.location = location;
        this.enabled = false;
        this.lifetime = (long)(lifetime * 1000.0);
        this.setInverted(false);
    }

    public Notification(String text, Coordinates location, double lifetime, boolean inverted) {
        this.text = text;
        this.location = location;
        this.enabled = false;
        this.lifetime = (long)(lifetime * 1000.0);
        this.setInverted(inverted);
    }

    public String getText() {
        return this.text;
    }

    public Coordinates getLocation() {
        return this.location;
    }

    public void setEnabled(boolean enabled) {
        if (!this.enabled && enabled) {
            this.startTime = System.currentTimeMillis();
        }
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isDone() {
        return this.enabled && System.currentTimeMillis() >= this.startTime + this.lifetime;
    }

    public void setPointTo(ScreenPoint point) {
        this.pointTo = point;
    }

    ScreenPoint getPointTo() {
        return this.pointTo;
    }

    Dimension getDrawSize(Graphics2D g) {
        Rectangle2D bounds = DrawUtilities.getStringBounds(g, this.text);
        return new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
    }

    void draw(Graphics2D g, Rectangle rect) {
        DrawUtilities.drawCenteredText(g, this.text, rect);
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public boolean isInverted() {
        return this.inverted;
    }
}

