/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.entitydrawers;

import hectare.model.Coordinates;
import hectare.view.CoordinateConverter;
import hectare.view.EntityDrawer;
import hectare.view.ScreenPoint;
import hectare.view.utilities.ImageUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;

public class SpriteEntityDrawer
extends EntityDrawer {
    private final String entityName;
    private final Color minimapColor;
    private final ScreenPoint origin;
    private final float widthScale;
    private boolean scaled;
    private Image image;

    public SpriteEntityDrawer(String entityName, String spriteName, float widthScale, ScreenPoint origin, Color minimapColor) {
        this.image = ImageUtilities.loadSpriteWithoutCache(spriteName);
        this.entityName = entityName;
        this.minimapColor = minimapColor;
        this.widthScale = widthScale;
        this.origin = origin;
        this.scaled = false;
    }

    private void scaleImage(int width) {
        this.image = ImageUtilities.scaleToWidth(this.image, width);
        ImageUtilities.ensureSizeIsLoaded(this.image);
        this.origin.x *= (float)this.image.getWidth(null);
        this.origin.y *= (float)this.image.getHeight(null);
        this.scaled = true;
    }

    @Override
    public void draw(Graphics2D g, Coordinates coords, CoordinateConverter converter) {
        ScreenPoint center = converter.tileCenter(coords);
        g.drawImage(this.image, (int)(center.x - this.origin.x), (int)(center.y - this.origin.y), null);
    }

    @Override
    public Rectangle getDrawArea(Coordinates coords, CoordinateConverter converter) {
        if (!this.scaled) {
            this.scaleImage((int)(this.widthScale * converter.getTileWidth()));
        }
        ScreenPoint center = converter.tileCenter(coords);
        return new Rectangle((int)(center.x - this.origin.x), (int)(center.y - this.origin.y), this.image.getWidth(null), this.image.getHeight(null));
    }

    @Override
    public void drawMini(Graphics2D g, Coordinates coords, CoordinateConverter converter) {
        Shape tileShape = converter.mapRectToScreen(coords.getX(), coords.getY(), 1, 1);
        g.setColor(this.minimapColor);
        g.fill(tileShape);
    }

    @Override
    public void drawQueryInfo(Graphics2D g, Rectangle region) {
        int x = region.x;
        int y = region.y + 15;
        g.setColor(Color.black);
        g.drawString(this.entityName, x, y);
    }

    @Override
    public Dimension getQuerySize() {
        return new Dimension(200, 30);
    }
}

