/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.layers;

import hectare.Debug;
import hectare.model.GameState;
import hectare.view.Layer;
import hectare.view.NotificationSystem;
import hectare.view.utilities.DrawUtilities;
import hectare.view.widgets.IsoView;
import hectare.view.widgets.Menubar;
import hectare.view.widgets.Minimap;
import hectare.view.widgets.Toolbar;
import hectare.view.widgets.TopBar;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class GameLayer
extends Layer {
    private static final long serialVersionUID = 1L;
    private static final int TOOLBAR_HEIGHT = 80;
    private static final int MINIMAP_HEIGHT = 150;
    private static final int MENUBAR_WIDTH = 150;
    private static final int TOPBAR_HEIGHT = 40;
    private final int TOOLBAR_DISPLACEMENT_X;
    private final int TOOLBAR_DISPLACEMENT_Y;
    private final GameState state;
    private IsoView isoView;
    private Minimap minimap;
    private Toolbar toolbar;
    private TopBar topbar;

    public GameLayer(int width, int height, GameState s) {
        super(width, height);
        this.state = s;
        this.isoView = new IsoView(width, height - 80, this.state);
        this.minimap = new Minimap(300, 150, this.isoView);
        this.toolbar = new Toolbar(width - 150, 80, 300, this.state, this.isoView);
        Menubar menubar = new Menubar(150, 80);
        this.topbar = new TopBar(width, 40, this.state, this.isoView);
        this.add(this.isoView, 0, 0);
        this.TOOLBAR_DISPLACEMENT_X = 0;
        this.TOOLBAR_DISPLACEMENT_Y = height - 80;
        this.add(this.toolbar, this.TOOLBAR_DISPLACEMENT_X, this.TOOLBAR_DISPLACEMENT_Y);
        this.add(menubar, width - 150, height - 80);
        this.add(this.minimap, 5, height - 150 - 5);
        this.add(this.topbar, 0, 0);
        NotificationSystem ns = NotificationSystem.getInstance();
        ns.addHandler("ISOVIEW", this.isoView);
        ns.addHandler("MINIMAP", this.minimap);
        ns.addHandler("TOOLBAR", this.toolbar);
        ns.addHandler("TOPBAR", this.topbar);
        Debug.write(this, "GameLayer created");
    }

    @Override
    public void tick(long elapsedMilliseconds) {
        if (this.state.getStepInterpolation() == 1.0) {
            this.state.step();
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        DrawUtilities.selectDefaultFont((Graphics2D)g);
        NotificationSystem.getInstance().paint((Graphics2D)g);
        this.toolbar.drawMouseOver((Graphics2D)g, this.TOOLBAR_DISPLACEMENT_X, this.TOOLBAR_DISPLACEMENT_Y);
    }

    public GameState getState() {
        return this.state;
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }
}

