/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.overlays;

import hectare.model.Coordinates;
import hectare.model.Tile;
import hectare.view.CoordinateConverter;
import hectare.view.Overlay;
import hectare.view.utilities.DrawUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;

public class TemperatureOverlay
implements Overlay {
    private static final Color HOT = Color.red;
    private static final Color COLD = Color.blue;
    private static final float SCALE = 0.5f;
    private String myName = "Temperature";

    @Override
    public void draw(Graphics2D g, Coordinates c, Tile t, CoordinateConverter converter) {
        Shape tileShape = converter.mapRectToScreen(c.getX(), c.getY(), 1, 1);
        double factor = Math.min(t.getTemperature() * 0.5, 0.95);
        Color tileColor = DrawUtilities.mixColors(COLD, HOT, factor);
        g.setColor(tileColor);
        g.fill(tileShape);
    }

    @Override
    public int getDrawOrder() {
        return 1;
    }

    @Override
    public String currentName() {
        return this.myName;
    }
}

