/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.utilities;

import hectare.view.ScreenPoint;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.AttributedString;
import java.util.Hashtable;

public abstract class DrawUtilities {
    private static final int BUBBLE_PADDING = 10;
    private static final int BUBBLE_POINTER_LENGTH = 75;
    private static final int BUBBLE_INVERTED_POINTER_LENGTH = 40;
    private static final int BUBBLE_POINTER_WIDTH = 20;
    private static final Color BUBBLE_BG_COLOR = new Color(250, 249, 192);
    private static final Color BUBBLE_STROKE_COLOR = Color.black;
    private static final Hashtable<String, Font> fontCache = new Hashtable();
    private static final String FONT_PATH = "/fonts/";
    private static final String DEFAULT_FONT = "Laffayette_Comic_Pro.ttf";
    private static final float DEFAULT_FONT_SIZE = 12.0f;

    public static void selectDefaultFont(Graphics2D g) {
        DrawUtilities.selectFont(g, DEFAULT_FONT);
    }

    public static void selectFont(Graphics2D g, String fontname) {
        Font f = fontCache.get(fontname);
        if (f == null) {
            try {
                URL url = DrawUtilities.class.getResource(FONT_PATH + fontname);
                if (url == null) {
                    throw new IOException("Font not found: " + fontname);
                }
                InputStream is = url.openStream();
                f = Font.createFont(0, is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (FontFormatException e) {
                e.printStackTrace();
            }
            fontCache.put(fontname, f);
        }
        f = f.deriveFont(12.0f);
        g.setFont(f);
    }

    public static void selectFontSize(Graphics2D g, float size) {
        g.setFont(g.getFont().deriveFont(size));
    }

    public static Rectangle drawBubble(Graphics2D g, Dimension size, ScreenPoint location, Color bg, Color border, int pointerLength, int pointerWidth) {
        Object aa_setting = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = (int)((double)location.x - size.getWidth() / 2.0);
        int y = (int)((double)location.y - size.getHeight() - (double)pointerLength - 10.0);
        int w = size.width;
        int h = size.height;
        int pointerX1 = (int)location.x + pointerWidth / 2;
        int pointerX2 = (int)location.x - pointerWidth / 2;
        if (x < 10) {
            x = 10;
            pointerX1 = Math.max(pointerX1, x + pointerWidth);
            pointerX2 = Math.max(pointerX2, x);
        }
        GeneralPath bgShape = new GeneralPath();
        bgShape.moveTo(x - 10, y);
        bgShape.quadTo(x - 10, y - 10, x, y - 10);
        bgShape.lineTo(x + w, y - 10);
        bgShape.quadTo(x + w + 10, y - 10, x + w + 10, y);
        bgShape.lineTo(x + w + 10, y + h);
        bgShape.quadTo(x + w + 10, y + h + 10, x + w, y + h + 10);
        bgShape.lineTo(pointerX1, y + h + 10);
        bgShape.lineTo((int)location.x, (int)location.y);
        bgShape.lineTo(pointerX2, y + h + 10);
        bgShape.lineTo(x, y + h + 10);
        bgShape.quadTo(x - 10, y + h + 10, x - 10, y + h);
        bgShape.closePath();
        g.setColor(bg);
        g.fill(bgShape);
        g.setColor(border);
        g.draw(bgShape);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa_setting);
        return new Rectangle(x, y, size.width, size.height);
    }

    public static Rectangle drawInvertedBubble(Graphics2D g, Dimension size, ScreenPoint location, Color bg, Color border, int pointerLength, int pointerWidth) {
        Object aa_setting = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = (int)((double)location.x - size.getWidth() / 2.0);
        int y = (int)((double)location.y + size.getHeight() + (double)pointerLength + 10.0);
        int w = size.width;
        int h = size.height;
        int pointerX1 = (int)location.x + pointerWidth / 2;
        int pointerX2 = (int)location.x - pointerWidth / 2;
        if (x < 10) {
            x = 10;
            pointerX1 = Math.max(pointerX1, x + pointerWidth);
            pointerX2 = Math.max(pointerX2, x);
        }
        GeneralPath bgShape = new GeneralPath();
        bgShape.moveTo(x - 10, y);
        bgShape.quadTo(x - 10, y - 10, x, y - 10);
        bgShape.lineTo(pointerX2, y - 10);
        bgShape.lineTo((int)location.x, (int)location.y);
        bgShape.lineTo(pointerX1, y - 10);
        bgShape.lineTo(x + w, y - 10);
        bgShape.quadTo(x + w + 10, y - 10, x + w + 10, y);
        bgShape.lineTo(x + w + 10, y + h);
        bgShape.quadTo(x + w + 10, y + h + 10, x + w, y + h + 10);
        bgShape.lineTo(x, y + h + 10);
        bgShape.quadTo(x - 10, y + h + 10, x - 10, y + h);
        bgShape.closePath();
        g.setColor(bg);
        g.fill(bgShape);
        g.setColor(border);
        g.draw(bgShape);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa_setting);
        return new Rectangle(x, y, size.width, size.height);
    }

    public static Rectangle drawBubble(Graphics2D g, Dimension size, ScreenPoint location) {
        return DrawUtilities.drawBubble(g, size, location, BUBBLE_BG_COLOR, BUBBLE_STROKE_COLOR, 75, 20);
    }

    public static Rectangle drawBubble(Graphics2D g, Dimension size, ScreenPoint location, boolean inverted) {
        if (inverted) {
            return DrawUtilities.drawInvertedBubble(g, size, location, BUBBLE_BG_COLOR, BUBBLE_STROKE_COLOR, 40, 20);
        }
        return DrawUtilities.drawBubble(g, size, location, BUBBLE_BG_COLOR, BUBBLE_STROKE_COLOR, 75, 20);
    }

    public static Rectangle2D getStringBounds(Graphics2D g, String s) {
        FontMetrics metrics = g.getFontMetrics();
        if (s.indexOf("\n") == -1) {
            return metrics.getStringBounds(s, g);
        }
        String[] temp = s.split("\n");
        int h = 0;
        int w = 0;
        int i = 0;
        while (i < temp.length) {
            Rectangle2D m = metrics.getStringBounds(temp[i], g);
            int temph = (int)m.getHeight();
            int tempw = (int)m.getWidth();
            h += temph;
            if (tempw > w) {
                w = tempw;
            }
            ++i;
        }
        return new Rectangle(w, h);
    }

    public static void drawCenteredString(Graphics2D g, String s, Rectangle bounds) {
        Rectangle2D stringBounds = DrawUtilities.getStringBounds(g, s);
        Rectangle stringRect = DrawUtilities.getCenteredRect((int)stringBounds.getWidth(), (int)stringBounds.getHeight(), bounds);
        g.drawString(s, stringRect.x, stringRect.y + stringRect.height);
    }

    public static void drawCenteredText(Graphics2D g, String s, Rectangle bounds) {
        AttributedString toDraw = new AttributedString(s);
        toDraw.addAttribute(TextAttribute.FONT, g.getFont());
        LineBreakMeasurer measurer = new LineBreakMeasurer(toDraw.getIterator(), g.getFontRenderContext());
        double textWidth = 0.0;
        double textHeight = 0.0;
        while (measurer.getPosition() < s.length()) {
            int forcedLinebreak = s.indexOf(10, measurer.getPosition() + 1);
            if (forcedLinebreak == -1) {
                forcedLinebreak = s.length() + 1;
            }
            TextLayout line = measurer.nextLayout((float)bounds.getWidth(), forcedLinebreak, false);
            textWidth = Math.max(textWidth, line.getBounds().getWidth());
            textHeight += (double)(line.getAscent() + line.getDescent() + line.getLeading());
        }
        Rectangle textSpace = DrawUtilities.getCenteredRect((int)textWidth, (int)textHeight, bounds);
        Point2D.Double cursor = new Point2D.Double(textSpace.x, textSpace.y);
        DrawUtilities.drawStyledText(g, s, toDraw, cursor, (float)bounds.getWidth());
    }

    public static void drawStyledText(Graphics2D g, String s, AttributedString styled, Point2D cursor, float width) {
        LineBreakMeasurer measurer = new LineBreakMeasurer(styled.getIterator(), g.getFontRenderContext());
        while (measurer.getPosition() < s.length()) {
            int forcedLinebreak = s.indexOf(10, measurer.getPosition() + 1);
            if (forcedLinebreak == -1) {
                forcedLinebreak = s.length() + 1;
            }
            TextLayout line = measurer.nextLayout(width, forcedLinebreak, false);
            cursor.setLocation(cursor.getX(), cursor.getY() + (double)line.getAscent());
            line.draw(g, (float)cursor.getX(), (float)cursor.getY());
            cursor.setLocation(cursor.getX(), cursor.getY() + (double)line.getDescent() + (double)line.getLeading());
        }
    }

    public static Rectangle getCenteredRect(int width, int height, Rectangle bounds) {
        return (Rectangle)DrawUtilities.center(new Rectangle(0, 0, width, height), bounds);
    }

    public static RectangularShape center(RectangularShape toCenter, RectangularShape bounds) {
        RectangularShape toReturn = (RectangularShape)toCenter.clone();
        toReturn.setFrame(bounds.getCenterX() - toCenter.getWidth() / 2.0, bounds.getCenterY() - toCenter.getHeight() / 2.0, toCenter.getWidth(), toCenter.getHeight());
        return toReturn;
    }

    public static Color mixColors(Color c1, Color c2, double factor) {
        return new Color((int)((double)c1.getRed() - (double)(c1.getRed() - c2.getRed()) * factor), (int)((double)c1.getGreen() - (double)(c1.getGreen() - c2.getGreen()) * factor), (int)((double)c1.getBlue() - (double)(c1.getBlue() - c2.getBlue()) * factor));
    }

    public static Composite setOpacity(Graphics2D g, float opacity) {
        Composite oldComposite = g.getComposite();
        AlphaComposite newComposite = AlphaComposite.getInstance(3, opacity);
        g.setComposite(newComposite);
        return oldComposite;
    }

    public static Object enableAA(Graphics2D g) {
        Object oldAA = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return oldAA;
    }

    public static void restoreAA(Graphics2D g, Object oldAA) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAA);
    }
}

