/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.model.Cloud;
import hectare.view.CoordinateConverter;
import hectare.view.IsoPoint;
import hectare.view.ScreenPoint;
import hectare.view.utilities.DrawUtilities;
import hectare.view.utilities.ImageUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

class CloudDrawer {
    private static final int IMAGE_FORMAT = 2;
    private static final float RAIN_FREQ = 0.01f;
    private static final float RAIN_SPEED = 2.5f;
    private static final int CLOUD_HEIGHT = 25;
    private static final float CLOUD_IMAGE_ASPECT_RATIO = 0.7f;
    private static final float SHADOW_OPACITY = 0.3f;
    private final CoordinateConverter converter;
    private final ArrayList<IsoPoint> rainDrops;
    private final Image cloudImage;
    private final Image raincloudImage;
    private final Image cloudShadowImage;
    private final Image raindropImage;
    private final Rectangle screenRect;
    private Image cloudBuffer;
    private Graphics2D cloudCanvas;
    private Image shadowBuffer;
    private Graphics2D shadowCanvas;

    public CloudDrawer(int width, int height, CoordinateConverter converter) {
        this.screenRect = new Rectangle(width, height);
        this.converter = converter;
        this.raindropImage = this.buildRaindropImage();
        int cloudImageWidth = (int)converter.getTileWidth();
        int cloudImageHeight = (int)(converter.getTileWidth() * 0.7f);
        this.cloudImage = ImageUtilities.loadSpriteWithoutCache("cloud.png").getScaledInstance(cloudImageWidth, cloudImageHeight, 4);
        this.raincloudImage = ImageUtilities.loadSpriteWithoutCache("cloud_raining.png").getScaledInstance((int)converter.getTileWidth(), cloudImageHeight, 4);
        this.cloudShadowImage = ImageUtilities.loadSpriteWithoutCache("cloud_shadow.png").getScaledInstance(cloudImageWidth, cloudImageHeight, 4);
        this.rainDrops = new ArrayList();
        this.shadowBuffer = new BufferedImage(width, height, 2);
        this.shadowCanvas = (Graphics2D)this.shadowBuffer.getGraphics();
        this.cloudBuffer = new BufferedImage(width, height, 2);
        this.cloudCanvas = (Graphics2D)this.cloudBuffer.getGraphics();
    }

    private Image buildRaindropImage() {
        int height = (int)(this.converter.getTileHeight() / 2.0f);
        BufferedImage image = new BufferedImage(1, height, 2);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        int i = 0;
        while (i < height) {
            g.setColor(new Color(0.0f, 0.5f, 0.9f, (float)i / (float)height));
            g.fillRect(0, i, 1, 1);
            ++i;
        }
        g.dispose();
        return image;
    }

    public void clearBuffers() {
        Composite oldComposite = this.shadowCanvas.getComposite();
        this.shadowCanvas.setComposite(AlphaComposite.Clear);
        this.shadowCanvas.fillRect(0, 0, this.screenRect.width, this.screenRect.height);
        this.shadowCanvas.setComposite(oldComposite);
        oldComposite = this.shadowCanvas.getComposite();
        this.cloudCanvas.setComposite(AlphaComposite.Clear);
        this.cloudCanvas.fillRect(0, 0, this.screenRect.width, this.screenRect.height);
        this.cloudCanvas.setComposite(oldComposite);
    }

    public void flushBuffers(Graphics2D g) {
        Composite oldComposite = DrawUtilities.setOpacity(g, 0.3f);
        g.drawImage(this.shadowBuffer, 0, 0, null);
        g.setComposite(oldComposite);
        g.drawImage(this.cloudBuffer, 0, 0, null);
    }

    public void drawRain() {
        int i = 0;
        while (i < this.rainDrops.size()) {
            IsoPoint drop = this.rainDrops.get(i);
            IsoPoint top = new IsoPoint(drop.x, drop.y, drop.z + 15.0f);
            IsoPoint bottom = new IsoPoint(drop.x, drop.y, 0.0f);
            this.cloudCanvas.setClip(new Rectangle((int)this.converter.getScreenPosition((IsoPoint)top).x, (int)this.converter.getScreenPosition((IsoPoint)top).y, 1, (int)(this.converter.getScreenPosition((IsoPoint)bottom).y - this.converter.getScreenPosition((IsoPoint)top).y)));
            ScreenPoint screenPos = this.converter.getScreenPosition(drop);
            this.cloudCanvas.drawImage(this.raindropImage, (int)screenPos.x, (int)screenPos.y - this.raindropImage.getHeight(null), null);
            drop.z -= 2.5f;
            if (drop.z < (float)(-this.raindropImage.getHeight(null))) {
                this.rainDrops.remove(i);
                --i;
            }
            ++i;
        }
        this.cloudCanvas.setClip(null);
    }

    public void drawCloud(double interpolation, Cloud cloud) {
        Image img;
        float x = (float)cloud.getXInterpolated(interpolation);
        float y = (float)cloud.getYInterpolated(interpolation);
        IsoPoint tileCenter = new IsoPoint(x + 0.5f, y + 0.5f, 25.0f);
        ScreenPoint origin = this.converter.getScreenPosition(tileCenter);
        origin.x -= (float)(this.cloudImage.getWidth(null) / 2);
        origin.y -= (float)(this.cloudImage.getHeight(null) / 2);
        Image image = img = cloud.isRaining() ? this.raincloudImage : this.cloudImage;
        if (this.screenRect.intersects(new Rectangle((int)origin.x, (int)origin.y, img.getWidth(null), img.getHeight(null)))) {
            if (cloud.isRaining() && Math.random() > (double)0.01f) {
                this.rainDrops.add(new IsoPoint((float)((double)x + Math.random()), (float)((double)y + Math.random()), 25.0f));
            }
            this.cloudCanvas.drawImage(img, (int)origin.x, (int)origin.y, null);
        }
        tileCenter.z -= 25.0f;
        origin = this.converter.getScreenPosition(tileCenter);
        origin.x -= (float)(this.cloudImage.getWidth(null) / 2);
        origin.y -= (float)(this.cloudImage.getHeight(null) / 2);
        if (this.screenRect.intersects(new Rectangle((int)origin.x, (int)origin.y, this.cloudShadowImage.getWidth(null), this.cloudShadowImage.getHeight(null)))) {
            this.shadowCanvas.drawImage(this.cloudShadowImage, (int)origin.x, (int)origin.y, null);
        }
    }
}

