/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.Debug;
import hectare.SoundSystem;
import hectare.controller.Tool;
import hectare.model.Cloud;
import hectare.model.Coordinates;
import hectare.model.Entity;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.TownEntity;
import hectare.model.WaterEntity;
import hectare.model.World;
import hectare.view.CoordinateConverter;
import hectare.view.EntityDrawer;
import hectare.view.IsoPoint;
import hectare.view.Notification;
import hectare.view.NotificationHandler;
import hectare.view.Overlay;
import hectare.view.ScreenPoint;
import hectare.view.Widget;
import hectare.view.overlays.NutrientOverlay;
import hectare.view.overlays.TemperatureOverlay;
import hectare.view.overlays.WindOverlay;
import hectare.view.utilities.DrawUtilities;
import hectare.view.utilities.ImageUtilities;
import hectare.view.widgets.CloudDrawer;
import hectare.view.widgets.QueryDrawer;
import hectare.view.widgets.WaterCornerDrawer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.Map;

public class IsoView
extends Widget
implements MouseMotionListener,
MouseListener,
NotificationHandler {
    private static final long serialVersionUID = 1L;
    private static final int DRAG_TOLERANCE = 20;
    private static final float TILE_WIDTH = 64.0f;
    private static final float TILE_HEIGHT = 32.0f;
    private static final Color DRY_LAND = new Color(170, 170, 100);
    private static final Color WET_LAND = new Color(30, 160, 30);
    private static final Color GRID_COLOR = new Color(61, 98, 32);
    public static final Overlay NO_OVERLAY = null;
    public static final Overlay WIND_OVERLAY = new WindOverlay();
    public static final Overlay TEMP_OVERLAY = new TemperatureOverlay();
    public static final Overlay NUTRIENT_OVERLAY = new NutrientOverlay();
    private final CoordinateConverter converter;
    private final GameState state;
    private final World world;
    private final Point mouse;
    private int dragDistance;
    private Coordinates activeTile;
    private Tool lastSelectedTool;
    private boolean lastWasUsable;
    private Shape mapRegion;
    private Overlay currentOverlay;
    private final CloudDrawer cloudDrawer;
    private final QueryDrawer queryDrawer;

    public IsoView(int width, int height, GameState s) {
        super(width, height);
        this.state = s;
        this.world = this.state.getWorld();
        this.converter = new CoordinateConverter(64.0f, 32.0f);
        this.correctViewPos();
        Point mousePos = this.getMousePosition();
        this.mouse = mousePos != null ? mousePos : new Point(-50, -50);
        this.dragDistance = 0;
        this.cloudDrawer = new CloudDrawer(width, height, this.converter);
        this.queryDrawer = new QueryDrawer();
        this.setCurrentOverlay(NO_OVERLAY);
        if (this.world.getInitTownLoc() != null) {
            this.centerOnPosition(this.world.getInitTownLoc());
        }
        this.recalculateMapRegion();
        this.recalculateActiveTile();
        this.lastSelectedTool = null;
        this.lastWasUsable = false;
        Debug.write(this, "Initialized with state: " + s);
        Debug.write(this, "World size: " + this.world.getWidth() + "x" + this.world.getHeight());
        Debug.write(this, "Mouse position: " + this.mouse);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void setCurrentOverlay(Overlay currentOverlay) {
        this.currentOverlay = currentOverlay;
    }

    public Overlay getCurrentOverlay() {
        return this.currentOverlay;
    }

    GameState getState() {
        return this.state;
    }

    World getWorld() {
        return this.world;
    }

    CoordinateConverter getCurrentConverter() {
        return this.converter;
    }

    private void recalculateMapRegion() {
        this.mapRegion = this.converter.mapRectToScreen(0, 0, this.world.getWidth(), this.world.getHeight());
    }

    private void recalculateActiveTile() {
        this.activeTile = this.tileAtPoint(this.mouse);
    }

    private Coordinates tileAtPoint(Point p) {
        Coordinates c = null;
        if (this.mapRegion.contains(p)) {
            IsoPoint cursorTile = this.converter.getIsoPosition(p.x, p.y);
            c = new Coordinates((int)cursorTile.x, (int)cursorTile.y);
        }
        return c;
    }

    boolean isOnScreen(Rectangle rect) {
        return rect.intersects(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    private boolean isOnScreen(Coordinates c) {
        ScreenPoint p = this.converter.tileCenter(c);
        float halfWidth = this.converter.getTileWidth() / 2.0f;
        float halfHeight = this.converter.getTileHeight() / 2.0f;
        return p.x + halfWidth > 0.0f && p.x - halfWidth < (float)this.getWidth() && p.y + halfHeight > 0.0f && p.y - halfHeight < (float)this.getHeight();
    }

    @Override
    public void handleNotifications(Iterator<Notification> notifications) {
        while (notifications.hasNext()) {
            Notification n = notifications.next();
            if (this.isOnScreen(n.getLocation())) {
                n.setPointTo(this.converter.tileCenter(n.getLocation()));
                n.setEnabled(true);
                continue;
            }
            n.setEnabled(false);
        }
    }

    private void centerOnPositionWithoutCorrection(IsoPoint mapPosition) {
        ScreenPoint p = this.converter.getScreenPosition(mapPosition.x, mapPosition.y, 0.0f);
        int dx = (int)((double)this.getWidth() / 2.0 - p.getX());
        int dy = (int)((double)this.getHeight() / 2.0 - p.getY());
        this.converter.moveOrigin(dx, dy);
    }

    void centerOnPosition(IsoPoint mapPosition) {
        this.centerOnPositionWithoutCorrection(mapPosition);
        this.correctViewPos();
    }

    public void centerOnPosition(Coordinates mapPosition) {
        IsoPoint p = new IsoPoint(mapPosition.getX(), mapPosition.getY(), 0.0f);
        this.centerOnPosition(p);
    }

    private void scrollWorld(int dx, int dy) {
        this.converter.moveOrigin(dx, dy);
        this.correctViewPos();
        this.recalculateMapRegion();
    }

    private void correctViewPos() {
        IsoPoint midpoint = this.converter.getIsoPosition((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        midpoint.x = Math.max(midpoint.x, 0.0f);
        midpoint.y = Math.max(midpoint.y, 0.0f);
        midpoint.x = Math.min(midpoint.x, (float)this.world.getWidth());
        midpoint.y = Math.min(midpoint.y, (float)this.world.getHeight());
        this.centerOnPositionWithoutCorrection(midpoint);
    }

    private void drawTile(Graphics2D g, Tile t, EntityDrawer drawer, Shape tileShape) {
        double waterRange = Tile.getMaxWater() - Tile.getMinWater();
        double groundwater = (t.getGroundwater() - Tile.getMinWater()) / waterRange;
        Color tileColor = DrawUtilities.mixColors(DRY_LAND, WET_LAND, groundwater);
        g.setColor(tileColor);
        g.fill(tileShape);
    }

    private void drawCursor(Graphics2D g, Shape tileShape) {
        Composite oldComposite = DrawUtilities.setOpacity(g, 0.66f);
        g.setColor(Color.yellow);
        g.fill(tileShape);
        g.setComposite(oldComposite);
    }

    private void drawGrid(Graphics2D g, int x, int y) {
        ScreenPoint top = this.converter.tileTopCorner(x, y);
        ScreenPoint left = this.converter.tileLeftCorner(x, y);
        ScreenPoint bottom = this.converter.tileBottomCorner(x, y);
        g.setColor(GRID_COLOR);
        g.draw(new Line2D.Float(top.x, top.y, left.x, left.y));
        g.draw(new Line2D.Float(bottom.x, bottom.y, left.x, left.y));
    }

    private void updateCursor() {
        Tool currentTool = this.state.getCurrentTool();
        if (currentTool == null) {
            return;
        }
        Point mousePos = this.getMousePosition();
        if (mousePos == null) {
            return;
        }
        Coordinates tileCoordinates = this.tileAtPoint(mousePos);
        boolean usable = tileCoordinates == null ? false : currentTool.canApply(tileCoordinates, this.world);
        if (this.state.getCurrentTool() != this.lastSelectedTool || this.lastWasUsable != usable) {
            this.lastSelectedTool = this.state.getCurrentTool();
            this.lastWasUsable = usable;
            Image i = ImageUtilities.createImage(50, 50);
            Graphics2D g = (Graphics2D)i.getGraphics();
            Image toolImg = ImageUtilities.loadSprite(this.state.getCurrentTool().getIcon());
            ImageUtilities.ensureSizeIsLoaded(toolImg);
            Debug.write(this, "Updating tool cursor");
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (toolImg.getWidth(this) < toolImg.getHeight(this)) {
                ImageUtilities.ensureCompleteDraw(g, toolImg, 0, 0, (int)(50.0f / (float)toolImg.getHeight(this) * (float)toolImg.getWidth(this)), 50);
            } else {
                ImageUtilities.ensureCompleteDraw(g, toolImg, 0, 0, 50, (int)(50.0f / (float)toolImg.getWidth(this) * (float)toolImg.getHeight(this)));
            }
            if (!usable) {
                g.setColor(Color.red);
                Stroke oldStroke = g.getStroke();
                Object oldAA = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setStroke(new BasicStroke(3.0f));
                g.drawOval(5, 5, 40, 40);
                g.drawLine(5, 5, 40, 40);
                g.setStroke(oldStroke);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAA);
            }
            Polygon p = new Polygon();
            p.addPoint(0, 0);
            p.addPoint(0, 10);
            p.addPoint(10, 0);
            g.setColor(Color.white);
            g.fill(p);
            g.setColor(Color.black);
            g.draw(p);
            Toolkit tk = Toolkit.getDefaultToolkit();
            String toolName = this.state.getCurrentTool().getDisplayName();
            Point cursorOrigin = new Point(0, 0);
            Cursor c = tk.createCustomCursor(i, cursorOrigin, toolName);
            this.setCursor(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void draw(Graphics2D g) {
        Coordinates c;
        this.updateCursor();
        g.setColor(new Color(64, 112, 0));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Iterator<Coordinates> it = this.converter.getBackToFrontIterator(this.world, bounds);
        Entity entityAbove = null;
        Entity entityLeft = null;
        Entity entityBelow = null;
        Entity entityRight = null;
        this.cloudDrawer.clearBuffers();
        this.cloudDrawer.drawRain();
        GameState gameState = this.state;
        synchronized (gameState) {
            Map<Coordinates, Cloud> cloudMap = this.world.getCloudIndex();
            double interpolation = this.state.getStepInterpolation();
            while (it.hasNext()) {
                Cloud cloud;
                c = it.next();
                int x = c.getX();
                int y = c.getY();
                Shape tileShape = this.converter.mapRectToScreen(x, y, 1, 1);
                Tile tile = this.world.getTile(c);
                EntityDrawer drawer = tile.hasEntity() ? tile.getEntity().getDrawer() : null;
                boolean drawTile = this.isOnScreen(c);
                if (drawTile) {
                    if (this.currentOverlay == null || this.currentOverlay.getDrawOrder() == 2) {
                        this.drawTile(g, tile, drawer, tileShape);
                    }
                    if (this.currentOverlay != null && this.currentOverlay.getDrawOrder() == 0) {
                        this.currentOverlay.draw(g, c, tile, this.converter);
                    }
                    if (!(tile.getEntity() instanceof WaterEntity)) {
                        WaterCornerDrawer.drawWaterCorner(g, c, this.converter, this.world.getTile(c.getTopNeighbor()).getEntity(), this.world.getTile(c.getRightNeighbor()).getEntity(), this.world.getTile(c.getBottomNeighbor()).getEntity(), this.world.getTile(c.getLeftNeighbor()).getEntity(), this.world.getTile(c.getTopNeighbor().getRightNeighbor()).getEntity(), this.world.getTile(c.getTopNeighbor().getLeftNeighbor()).getEntity(), this.world.getTile(c.getBottomNeighbor().getRightNeighbor()).getEntity(), this.world.getTile(c.getBottomNeighbor().getLeftNeighbor()).getEntity());
                    }
                    if ((this.currentOverlay == null || this.currentOverlay.getDrawOrder() != 1) && drawer != null) {
                        entityAbove = this.world.getTile(c.getTopNeighbor()).getEntity();
                        entityLeft = this.world.getTile(c.getLeftNeighbor()).getEntity();
                        entityRight = this.world.getTile(c.getRightNeighbor()).getEntity();
                        entityBelow = this.world.getTile(c.getBottomNeighbor()).getEntity();
                        drawer.drawUnderGrid(g, c, this.converter, entityAbove, entityRight, entityBelow, entityLeft);
                    }
                    if (this.currentOverlay != null && this.currentOverlay.getDrawOrder() == 1) {
                        this.currentOverlay.draw(g, c, tile, this.converter);
                    }
                    this.drawGrid(g, x, y);
                    if (this.activeTile != null && x == this.activeTile.getX() && y == this.activeTile.getY()) {
                        this.drawCursor(g, tileShape);
                    }
                }
                if (drawer != null && drawer.getDrawArea(c, this.converter).intersects(this.getBounds())) {
                    drawer.draw(g, c, this.converter, entityAbove, entityRight, entityBelow, entityLeft);
                }
                if (drawTile && this.currentOverlay != null && this.currentOverlay.getDrawOrder() == 2) {
                    this.currentOverlay.draw(g, c, tile, this.converter);
                }
                if ((cloud = cloudMap.get(c)) == null) continue;
                this.cloudDrawer.drawCloud(interpolation, cloud);
            }
        }
        this.cloudDrawer.flushBuffers(g);
        c = this.world.getQueryLocation();
        if (c != null && this.isOnScreen(c)) {
            this.queryDrawer.drawQueryPopup(c, this.world.getTile(c), g, this.converter);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.scrollWorld(e.getX() - this.mouse.x, e.getY() - this.mouse.y);
        this.dragDistance = (int)((double)this.dragDistance + Math.sqrt(Math.pow(e.getX() - this.mouse.x, 2.0) + Math.pow(e.getY() - this.mouse.y, 2.0)));
        this.mouse.x = e.getX();
        this.mouse.y = e.getY();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.mouse.x = e.getX();
        this.mouse.y = e.getY();
        this.recalculateActiveTile();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Debug.write(this, "Mouse entered");
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.activeTile = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.dragDistance < 20) {
            if (this.activeTile == null) {
                return;
            }
            String sound = this.state.applyTool(this.activeTile) ? this.state.getCurrentTool().getSuccessSound() : this.state.getCurrentTool().getFailureSound();
            if (this.world.getTile(this.activeTile).getEntity() instanceof TownEntity && !((TownEntity)this.world.getTile(this.activeTile).getEntity()).isActive()) {
                this.world.unlockTown(this.activeTile);
            }
            SoundSystem.getInstance().playSound(sound);
        }
        this.dragDistance = 0;
    }
}

