/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.view.Widget;
import hectare.view.utilities.DrawUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class LoadScreen
extends Widget {
    private static final long serialVersionUID = 1L;
    private final int INITIAL_STEPS;
    private final int TEXT_HEIGHT;
    private int barLength;
    private List<String> messages = new ArrayList<String>();

    public LoadScreen(int width, int height) {
        this(width, height, 0);
    }

    public LoadScreen(int width, int height, int initialSteps) {
        super(width, height);
        this.messages.add("Cooling Molten Rock");
        this.messages.add("Reticulating Splines");
        this.messages.add("Raising Mountains");
        this.messages.add("Initializing Cloud Fluff");
        this.messages.add("Fertilizing Ground");
        this.messages.add("Planting Trees");
        this.messages.add("Removing All Mammoths");
        this.messages.add("Developing Civilization");
        this.INITIAL_STEPS = initialSteps;
        this.TEXT_HEIGHT = this.getHeight() / 2;
        this.barLength = 0;
    }

    @Override
    protected void draw(Graphics2D g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.white);
        DrawUtilities.drawCenteredString(g, this.getMessage(), new Rectangle(0, 0, this.getWidth(), this.TEXT_HEIGHT));
        DrawUtilities.drawCenteredString(g, "LOADING:", new Rectangle(0, 0, this.getWidth(), this.TEXT_HEIGHT + 40));
        Rectangle outlineRect = DrawUtilities.getCenteredRect(this.INITIAL_STEPS, 40, new Rectangle(0, 0, this.getWidth(), this.TEXT_HEIGHT + 100));
        g.draw(outlineRect);
        g.fillRect(outlineRect.x + 1, outlineRect.y + 1, this.barLength, 40);
    }

    protected String getMessage() {
        double progress = (double)this.barLength / (double)this.INITIAL_STEPS;
        int messageIndex = (int)Math.floor(progress * (double)this.messages.size());
        messageIndex = Math.min(messageIndex, this.messages.size() - 1);
        return this.messages.get(messageIndex);
    }

    public void barUpdate(int i) {
        this.barLength = i;
    }
}

