/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.Debug;
import hectare.Hectare;
import hectare.SoundSystem;
import hectare.view.utilities.DialogUtilities;
import hectare.view.utilities.DrawUtilities;
import hectare.view.utilities.ImageUtilities;
import hectare.view.widgets.AbstractMenuWidget;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;

public class MainMenu
extends AbstractMenuWidget<String> {
    private static final long serialVersionUID = 1L;
    private static final String INSTRUCTIONS = "Instructions";
    private static final String TUTORIAL = "Tutorial";
    private static final String NEW_GAME = "New Game";
    private static final String LOAD_GAME = "Load Game";
    private static final String EXIT_GAME = "Quit Hectare";
    private static final int TITLE_HEIGHT = 250;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 50;
    private static final int BUTTON_PADDING = 25;
    private final Image backgroundImage;
    private Shape instructionsShape = this.newCenteredButton("Instructions", 150, 50, 25, 250);
    private Shape tutorialShape = this.newCenteredButton("Tutorial", 150, 50, 25, 0);
    private Shape newGameShape = this.newCenteredButton("New Game", 150, 50, 25, 0);
    private Shape loadGameShape = this.newCenteredButton("Load Game", 150, 50, 25, 0);
    private Shape exitGameShape = this.newCenteredButton("Quit Hectare", 150, 50, 25, 0);

    public MainMenu(int width, int height) {
        super(width, height);
        this.backgroundImage = ImageUtilities.loadImageWithoutCache("/images/menu_bg.png");
        Debug.write(this, "Loading bg image: " + this.backgroundImage);
    }

    @Override
    protected void drawBackground(Graphics2D g) {
        ImageUtilities.ensureCompleteDraw(g, this.backgroundImage, 0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    protected void drawButtonWithColor(Graphics2D g, String object, Shape s, Color bgColor, Color strokeColor, Color textColor) {
        Object oldAA = DrawUtilities.enableAA(g);
        Composite oldComposite = DrawUtilities.setOpacity(g, 0.75f);
        g.setColor(bgColor);
        g.fill(s);
        g.setComposite(oldComposite);
        g.setColor(strokeColor);
        g.draw(s);
        g.setColor(textColor);
        DrawUtilities.drawCenteredString(g, object.toString(), s.getBounds());
        DrawUtilities.restoreAA(g, oldAA);
    }

    @Override
    protected void drawButton(Graphics2D g, String object, Shape s) {
        this.drawButtonWithColor(g, object, s, Color.black, Color.white, Color.white);
    }

    @Override
    protected void drawMouseOverButton(Graphics2D g, String object, Shape s) {
        this.drawButtonWithColor(g, object, s, Color.green, Color.black, Color.black);
    }

    @Override
    protected void buttonWasClicked(String object, Shape s) {
        if (s == this.instructionsShape) {
            Debug.write(this, "instructions");
            SoundSystem.getInstance().click();
            Hectare.showInstructions();
        } else if (s == this.tutorialShape) {
            Debug.write(this, "tutorial");
            SoundSystem.getInstance().click();
            Hectare.startTutorial();
        } else if (s == this.newGameShape) {
            Debug.write(this, "new game");
            SoundSystem.getInstance().click();
            Hectare.startGame();
        } else if (s == this.loadGameShape) {
            Debug.write(this, "load game");
            SoundSystem.getInstance().click();
            DialogUtilities.promptForLoadGame(this);
        } else if (s == this.exitGameShape) {
            Debug.write(this, "exit game");
            SoundSystem.getInstance().click();
            DialogUtilities.promptForExit(this);
        }
    }
}

