/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.model.Coordinates;
import hectare.model.Entity;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.World;
import hectare.view.CoordinateConverter;
import hectare.view.EntityDrawer;
import hectare.view.IsoPoint;
import hectare.view.Notification;
import hectare.view.NotificationHandler;
import hectare.view.ScreenPoint;
import hectare.view.Widget;
import hectare.view.widgets.IsoView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;

public class Minimap
extends Widget
implements MouseListener,
MouseMotionListener,
NotificationHandler {
    private static final long serialVersionUID = 1L;
    private static final Color MAP_BG_COLOR = new Color(150, 170, 90);
    private final IsoView view;
    private final Shape mapRegion;
    private final CoordinateConverter coord;
    private long lastUpdate;

    public Minimap(int width, int height, IsoView v) {
        super(width, height);
        this.view = v;
        World world = this.view.getWorld();
        int worldWidth = world.getWidth();
        int worldHeight = world.getHeight();
        this.coord = new CoordinateConverter(worldWidth, worldHeight, this.getBounds());
        this.mapRegion = this.coord.mapRectToScreen(0, 0, worldWidth, worldHeight);
        this.lastUpdate = 0L;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.mapRegion.contains(x, y);
    }

    private void addPolygonPoint(Polygon poly, ScreenPoint point) {
        poly.addPoint((int)point.getX(), (int)point.getY());
    }

    private ScreenPoint getMinimapPosition(float viewX, float viewY) {
        CoordinateConverter c = this.view.getCurrentConverter();
        IsoPoint pos = c.getIsoPosition(viewX, viewY);
        return this.coord.getScreenPosition(pos.x, pos.y, pos.z);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setClip(this.mapRegion);
        Polygon viewRegion = new Polygon();
        this.addPolygonPoint(viewRegion, this.getMinimapPosition(0.0f, 0.0f));
        this.addPolygonPoint(viewRegion, this.getMinimapPosition(this.view.getWidth(), 0.0f));
        this.addPolygonPoint(viewRegion, this.getMinimapPosition(this.view.getWidth(), this.view.getHeight()));
        this.addPolygonPoint(viewRegion, this.getMinimapPosition(0.0f, this.view.getHeight()));
        g.setColor(Color.white);
        g.drawPolygon(viewRegion);
        g.setClip(null);
    }

    @Override
    protected void draw(Graphics2D g) {
        GameState state = this.view.getState();
        if (state.getLastUpdateTime() <= this.lastUpdate) {
            return;
        }
        this.lastUpdate = state.getLastUpdateTime();
        this.clearAll();
        g.setColor(MAP_BG_COLOR);
        g.fill(this.mapRegion);
        World world = this.view.getWorld();
        Iterator<Coordinates> it = this.coord.getBackToFrontIterator(world);
        while (it.hasNext()) {
            Coordinates c = it.next();
            Tile thisTile = world.getTile(c);
            if (!thisTile.hasEntity()) continue;
            Entity entity = thisTile.getEntity();
            EntityDrawer drawer = entity.getDrawer();
            drawer.drawMini(g, c, this.coord);
        }
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(Color.black);
        g.draw(this.mapRegion);
        g.setStroke(oldStroke);
    }

    private void scrollToMouseEvent(MouseEvent e) {
        World world = this.view.getWorld();
        IsoPoint mapPoint = this.coord.getBestIsoPosition(world, e.getX(), e.getY());
        this.view.centerOnPosition(mapPoint);
        e.consume();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.scrollToMouseEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.scrollToMouseEvent(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void handleNotifications(Iterator<Notification> notifications) {
        while (notifications.hasNext()) {
            Notification n = notifications.next();
            n.setEnabled(true);
            n.setPointTo(this.coord.tileCenter(n.getLocation()));
        }
    }
}

