/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.model.Coordinates;
import hectare.model.Tile;
import hectare.view.CoordinateConverter;
import hectare.view.EntityDrawer;
import hectare.view.ScreenPoint;
import hectare.view.utilities.DrawUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

class QueryDrawer {
    private static final int LINE_HEIGHT = 15;
    private static final int DEFAULT_QUERYBOX_WIDTH = 175;
    private static final int DEFAULT_QUERYBOX_HEIGHT = 90;
    private static final int QUERYBOX_ENTITY_PADDNG = 15;
    private static final int BAR_LENGTH = 50;
    private static final int BAR_HEIGHT = 15;
    private static final int DIGITS_TO_DISPLAY = 3;
    private static final Color TEXT_COLOR = Color.black;
    private int x;
    private int y;

    QueryDrawer() {
    }

    private Dimension getContentSize(Tile t) {
        if (t.getEntity() != null) {
            EntityDrawer drawer = t.getEntity().getDrawer();
            Dimension entityQuerySize = drawer.getQuerySize();
            if (entityQuerySize == null || entityQuerySize.equals(new Dimension(0, 0))) {
                return new Dimension(175, 90);
            }
            if (drawer.drawUnderlyingTileInfo()) {
                int height = 90 + entityQuerySize.height + 15;
                int width = Math.max(175, entityQuerySize.width);
                return new Dimension(width, height);
            }
            return entityQuerySize;
        }
        return new Dimension(175, 90);
    }

    private String roundToNumDigits(double n, int digits) {
        double power = Math.pow(10.0, digits);
        n *= power;
        n = Math.round(n);
        String str = Double.toString(n /= power);
        int point = str.lastIndexOf(".");
        while (str.length() <= point + 3) {
            str = String.valueOf(str) + "0";
        }
        return str;
    }

    public void drawQueryPopup(Coordinates c, Tile t, Graphics2D g, CoordinateConverter converter) {
        ScreenPoint tileCenter = converter.tileCenter(c);
        Dimension size = this.getContentSize(t);
        EntityDrawer drawer = null;
        Rectangle r = DrawUtilities.drawBubble(g, size, tileCenter);
        this.x = r.x;
        this.y = r.y;
        if (t.getEntity() != null && (drawer = t.getEntity().getDrawer()).getQuerySize() != null) {
            int height = drawer.getQuerySize().height;
            drawer.drawQueryInfo(g, new Rectangle(this.x, this.y, size.width, height));
            this.y += height;
        }
        if (drawer == null || drawer.drawUnderlyingTileInfo()) {
            String labelWater = "Water: ";
            Rectangle2D boundsWater = DrawUtilities.getStringBounds(g, labelWater);
            String labelSun = "Sun: ";
            Rectangle2D boundsSun = DrawUtilities.getStringBounds(g, labelSun);
            String labelNut = "Nutrients: ";
            Rectangle2D boundsNut = DrawUtilities.getStringBounds(g, labelNut);
            int BAR_XALIGN = (int)Math.max(boundsNut.getWidth(), Math.max(boundsWater.getWidth(), boundsSun.getWidth()));
            this.drawInfo(g, t.getGroundwater(), Tile.getMinWater(), Tile.getMinGoodWater(), Tile.getMaxGoodWater(), Tile.getMaxWater(), labelWater, BAR_XALIGN);
            this.y += 15;
            this.drawInfo(g, t.getSun(), Tile.getMinSun(), Tile.getMinGoodSun(), Tile.getMaxGoodSun(), Tile.getMaxSun(), labelSun, BAR_XALIGN);
            this.y += 15;
            this.drawInfo(g, t.getNutrient(), Tile.getMinNutrient(), Tile.getMaxNutrient(), Tile.getMaxNutrient(), Tile.getMaxNutrient(), labelNut, BAR_XALIGN);
        }
    }

    private void drawInfo(Graphics2D g, double currentAmt, double minAmt, double minGoodAmt, double maxGoodAmt, double maxAmt, String label, int barAlign) {
        this.drawBar(g, new Point(this.x + barAlign, this.y), currentAmt, minAmt, minGoodAmt, maxGoodAmt, maxAmt);
        this.y += 15;
        g.setColor(TEXT_COLOR);
        g.drawString(label, this.x, this.y);
        g.drawString(this.roundToNumDigits(currentAmt, 3), this.x + barAlign + 50 + 15, this.y);
    }

    private void drawBar(Graphics2D g, Point barPos, double currentAmt, double minAmt, double minGoodAmt, double maxGoodAmt, double maxAmt) {
        int x = barPos.x;
        int y = barPos.y;
        if (currentAmt < minGoodAmt) {
            double hValue = (currentAmt - minAmt) / (minGoodAmt - minAmt);
            g.setColor(new Color(Color.HSBtoRGB((float)(hValue / 3.0), 1.0f, 1.0f)));
        } else if (currentAmt > maxGoodAmt) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.green);
        }
        g.fillRect(x, y, (int)(50.0 * ((currentAmt - minAmt) / (maxAmt - minAmt))), 15);
        g.setColor(Color.black);
        g.drawRect(x - 1, y - 1, 50, 16);
        g.drawRect(x - 1, y - 1, (int)(50.0 * ((minGoodAmt - minAmt) / (maxAmt - minAmt))), 16);
        g.drawRect(x - 1, y - 1, (int)(50.0 * ((maxGoodAmt - minAmt) / (maxAmt - minAmt))), 16);
    }
}

