/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.model.GameState;
import hectare.model.TownEntity;
import hectare.view.Notification;
import hectare.view.NotificationHandler;
import hectare.view.Overlay;
import hectare.view.ScreenPoint;
import hectare.view.utilities.DrawUtilities;
import hectare.view.widgets.AbstractMenuWidget;
import hectare.view.widgets.IsoView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class TopBar
extends AbstractMenuWidget<String>
implements NotificationHandler {
    private static final long serialVersionUID = 1L;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_YPADDING = 8;
    private static final int BUTTON_XPADDING = 10;
    private static final int TOTPOP_XALIGN = 15;
    private static final int NTOWN_XALIGN = 180;
    private static final int PGOAL_XALIGN = 325;
    private static final int PSCORE_XALIGN = 420;
    private static final String WIND = "Show Wind";
    private static final String TEMP = "Show Temperature";
    private static final String NUTR = "Show Nutrients";
    private static final String[] labels = new String[]{"Show Wind", "Show Temperature", "Show Nutrients"};
    private static final Overlay[] overlays = new Overlay[]{IsoView.WIND_OVERLAY, IsoView.TEMP_OVERLAY, IsoView.NUTRIENT_OVERLAY};
    private Rectangle toggleWindRect;
    private Rectangle toggleTempRect;
    private Rectangle toggleNutrRect;
    private final Shape[] buttons;
    private IsoView view;
    private GameState state;
    private long lastUpdate;

    public TopBar(int width, int height, GameState state, IsoView view) {
        super(width, height);
        this.buttons = new Shape[]{this.toggleWindRect, this.toggleTempRect, this.toggleNutrRect};
        this.state = state;
        this.lastUpdate = state.getLastUpdateTime();
        this.view = view;
        int BUTTON_HEIGHT = height - 16;
        int x = this.buttons.length;
        while (x > 0) {
            this.buttons[x - 1] = new Rectangle(width - x * 10 - x * 150, 8, 150, BUTTON_HEIGHT);
            --x;
        }
        x = 0;
        while (x < labels.length) {
            this.addButton(labels[x], this.buttons[x]);
            ++x;
        }
    }

    @Override
    public boolean needsRedraw() {
        return this.lastUpdate < this.state.getLastUpdateTime() || super.needsRedraw();
    }

    @Override
    protected void draw(Graphics2D g) {
        this.lastUpdate = this.state.getLastUpdateTime();
        super.draw(g);
        g.setColor(Color.white);
        String population = "Total population: ";
        population = String.valueOf(population) + TownEntity.toPopulation(this.state.getWorld().getTotalProsperity());
        Rectangle2D popBounds = DrawUtilities.getStringBounds(g, population);
        int popBoundsWidth = (int)popBounds.getWidth();
        DrawUtilities.drawCenteredString(g, population, new Rectangle(15, 0, popBoundsWidth, this.getHeight()));
        int townUnlockPopulation = TownEntity.toPopulation(this.state.getWorld().getNextTownProsperity());
        String nextTown = "";
        if (townUnlockPopulation >= 0) {
            nextTown = "Next town at: " + townUnlockPopulation;
        }
        Rectangle2D nTownBounds = DrawUtilities.getStringBounds(g, nextTown);
        int nTownBoundsWidth = (int)nTownBounds.getWidth();
        DrawUtilities.drawCenteredString(g, nextTown, new Rectangle(180, 0, nTownBoundsWidth, this.getHeight()));
        if (!this.state.isWon()) {
            String popGoal = "Goal: " + this.state.getPopulationGoal();
            Rectangle2D pGoalBounds = DrawUtilities.getStringBounds(g, popGoal);
            int pGoalBoundsWidth = (int)pGoalBounds.getWidth();
            DrawUtilities.drawCenteredString(g, popGoal, new Rectangle(325, 0, pGoalBoundsWidth, this.getHeight()));
            String score = "Score: " + this.state.getScore();
            Rectangle2D pScoreBounds = DrawUtilities.getStringBounds(g, score);
            int pScoreBoundsWidth = (int)pScoreBounds.getWidth();
            DrawUtilities.drawCenteredString(g, score, new Rectangle(420, 0, pScoreBoundsWidth, this.getHeight()));
        }
    }

    @Override
    protected void drawButton(Graphics2D g, String object, Shape s) {
        int x = 0;
        while (x < this.buttons.length) {
            if (s == this.buttons[x] && this.view.getCurrentOverlay() == overlays[x]) {
                this.drawButtonWithColor(g, object, s, Color.yellow, Color.orange, Color.black);
                return;
            }
            ++x;
        }
        super.drawButton(g, object, s);
    }

    @Override
    protected void buttonWasClicked(String object, Shape s) {
        int x = 0;
        while (x < this.buttons.length) {
            if (s == this.buttons[x]) {
                if (this.view.getCurrentOverlay() == overlays[x]) {
                    this.view.setCurrentOverlay(IsoView.NO_OVERLAY);
                } else {
                    this.view.setCurrentOverlay(overlays[x]);
                }
                return;
            }
            ++x;
        }
    }

    @Override
    public void handleNotifications(Iterator<Notification> notifications) {
        while (notifications.hasNext()) {
            Notification n = notifications.next();
            n.setEnabled(true);
            n.setPointTo(new ScreenPoint(200.0f, 40.0f));
        }
    }
}

