/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.Hectare;
import hectare.SoundSystem;
import hectare.view.utilities.DrawUtilities;
import hectare.view.widgets.AbstractMenuWidget;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;

public class TutorialMenu
extends AbstractMenuWidget<String> {
    private static final long serialVersionUID = 1L;
    private static final int TITLE_HEIGHT = 50;
    private static final int SUBTITLE_HEIGHT = 50;
    private static final int BUTTON_PADDING = 25;
    private static final String TITLE = "Tutorial Step";
    private static final String[] SUBTITLES = new String[]{"\tWelcome to the Hectare tutorial! Your goal for the game is to increase your population by growing enough food. You need to provide the crops with the right amount of water, sunlight, and nutrients for them to grow. Use the Magnifying glass tool by clicking to check on a plot of land. If you ever forget what you're supposed to do in this tutorial, just click the menu button on the bottom right.", "Your plants get water when clouds rain on them. With the second tool, you can make clouds begin raining. In the game, you can switch tools by clicking on any of the unlocked icons on the bottom of the screen. Make a rain cloud now.", "Good Job! New tools will unlock as you get a higher population. You can now use the wind tool to blow clouds away from a square. You can also see wind patterns by clicking on the \"Show Wind\" button at the top of the screen. For this tutorial your tool and overlay will be automatically changed. Try using the tool now with the wind patterns visible. ", "The next tool allows you to provide nutrients to the ground. You can see which areas of the map need nutrients by clicking the \u201cShow Nutrients\u201d button at the top of the screen. Use the tool to give nutrients to your plants with the nutrient levels visible.", "Next to the Nutrients map is a Temperature map. With your next tool, you can shine sunlight on areas, making them warmer\u2026 but be careful! Too much sunlight is bad for the crops. Heat up some area of the map now with the temperatures visible.", "With the next tool, you can create your own clouds just by clicking! Double clicking will produce a raining cloud which can make watering your plants a breeze. Make a cloud now.", "The next tool makes or destroys trees when you click. Trees will provide nutrients to the ground and allow your crops to keep water better. try making or destroying a tree now. ", "The final tool allows you to create or topple mountains. You may have seen that clouds have trouble getting by mountain tops. Try out the new tool. ", "Good job! now you know all the tools and maps. Also, as your population grows you will have more towns to care for. You can now go to the main menu and start a game. Good luck! "};
    private static final String CONTINUE_TUTORIAL = "Continue Tutorial";
    private static final String MAIN_MENU = "End Tutorial";
    private int currentStage;
    private static final String WIN_SOUND = "applause.wav";
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 50;
    private final Shape continueTutorial;
    private final Shape mainMenu;

    /*
     * Unable to fully structure code
     */
    private ArrayList<String> wrapText(int minlength, String text) {
        stringlength = text.length();
        substrings = stringlength / minlength;
        brokenText = new ArrayList<String>();
        i = 0;
        while (i < substrings) {
            end = minlength;
            if (end < text.length()) ** GOTO lbl10
            break;
lbl-1000:
            // 1 sources

            {
                ++end;
lbl10:
                // 2 sources

                ** while (!text.substring((int)(end - 1), (int)end).equals((Object)" ") && end < text.length())
            }
lbl11:
            // 1 sources

            brokenText.add(text.substring(0, end));
            text = text.substring(end);
            ++i;
        }
        brokenText.add(text);
        return brokenText;
    }

    public TutorialMenu(int width, int height, int stage) {
        super(width, height);
        this.currentStage = stage;
        this.continueTutorial = this.newCenteredButton(CONTINUE_TUTORIAL, 150, 50, 25, 200);
        this.mainMenu = this.newCenteredButton(MAIN_MENU, 150, 50, 25, 0);
        SoundSystem.getInstance().playSound(WIN_SOUND);
    }

    @Override
    protected void drawBackground(Graphics2D g) {
        this.clearAll();
        Composite opaque = DrawUtilities.setOpacity(g, 0.75f);
        super.drawBackground(g);
        g.setComposite(opaque);
        g.setColor(Color.white);
        DrawUtilities.drawCenteredString(g, TITLE, new Rectangle(0, 0, this.getWidth(), 50));
        ArrayList<String> instructions = this.wrapText(60, SUBTITLES[this.currentStage]);
        int i = 0;
        while (i < instructions.size()) {
            DrawUtilities.drawCenteredString(g, instructions.get(i), new Rectangle(0, 50, this.getWidth(), 50 + i * 25));
            ++i;
        }
    }

    @Override
    protected void buttonWasClicked(String object, Shape s) {
        if (s == this.continueTutorial) {
            Hectare.popLayer();
        } else if (s == this.mainMenu) {
            Hectare.popLayer();
            Hectare.popLayer();
        }
    }
}

