/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.model.Coordinates;
import hectare.model.Entity;
import hectare.model.WaterEntity;
import hectare.view.CoordinateConverter;
import hectare.view.ScreenPoint;
import hectare.view.entitydrawers.WaterDrawer;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

class WaterCornerDrawer {
    WaterCornerDrawer() {
    }

    public static void drawWaterCorner(Graphics2D g, Coordinates coords, CoordinateConverter converter, Entity top, Entity right, Entity bottom, Entity left, Entity topright, Entity topleft, Entity bottomright, Entity bottomleft) {
        GeneralPath shape;
        int x = coords.getX();
        int y = coords.getY();
        boolean roundTopCorner = left instanceof WaterEntity && top instanceof WaterEntity && topleft instanceof WaterEntity;
        boolean roundLeftCorner = left instanceof WaterEntity && bottom instanceof WaterEntity && bottomleft instanceof WaterEntity;
        boolean roundRightCorner = right instanceof WaterEntity && top instanceof WaterEntity && topright instanceof WaterEntity;
        boolean roundBottomCorner = right instanceof WaterEntity && bottom instanceof WaterEntity && bottomright instanceof WaterEntity;
        ScreenPoint topCorner = converter.tileTopCorner(x, y);
        ScreenPoint leftCorner = converter.tileLeftCorner(x, y);
        ScreenPoint rightCorner = converter.tileRightCorner(x, y);
        ScreenPoint bottomCorner = converter.tileBottomCorner(x, y);
        ScreenPoint topRightEdgeMidpoint = ScreenPoint.midpoint(topCorner, rightCorner);
        ScreenPoint topLeftEdgeMidpoint = ScreenPoint.midpoint(topCorner, leftCorner);
        ScreenPoint bottomRightEdgeMidpoint = ScreenPoint.midpoint(bottomCorner, rightCorner);
        ScreenPoint bottomLeftEdgeMidpoint = ScreenPoint.midpoint(bottomCorner, leftCorner);
        if (roundRightCorner) {
            shape = new GeneralPath();
            shape.moveTo(topRightEdgeMidpoint.x, topRightEdgeMidpoint.y);
            shape.quadTo(rightCorner.x, rightCorner.y, bottomRightEdgeMidpoint.x, bottomRightEdgeMidpoint.y);
            shape.lineTo(rightCorner.x, rightCorner.y);
            shape.lineTo(topRightEdgeMidpoint.x, topRightEdgeMidpoint.y);
            shape.closePath();
            g.setColor(WaterDrawer.WATER_COLOR);
            g.fill(shape);
        }
        if (roundBottomCorner) {
            shape = new GeneralPath();
            shape.moveTo(bottomLeftEdgeMidpoint.x, bottomLeftEdgeMidpoint.y);
            shape.quadTo(bottomCorner.x, bottomCorner.y, bottomRightEdgeMidpoint.x, bottomRightEdgeMidpoint.y);
            shape.lineTo(bottomCorner.x, bottomCorner.y);
            shape.lineTo(bottomLeftEdgeMidpoint.x, bottomLeftEdgeMidpoint.y);
            shape.closePath();
            g.setColor(WaterDrawer.WATER_COLOR);
            g.fill(shape);
        }
        if (roundLeftCorner) {
            shape = new GeneralPath();
            shape.moveTo(topLeftEdgeMidpoint.x, topLeftEdgeMidpoint.y);
            shape.quadTo(leftCorner.x, leftCorner.y, bottomLeftEdgeMidpoint.x, bottomLeftEdgeMidpoint.y);
            shape.lineTo(leftCorner.x, leftCorner.y);
            shape.lineTo(topLeftEdgeMidpoint.x, topLeftEdgeMidpoint.y);
            shape.closePath();
            g.setColor(WaterDrawer.WATER_COLOR);
            g.fill(shape);
        }
        if (roundTopCorner) {
            shape = new GeneralPath();
            shape.moveTo(topLeftEdgeMidpoint.x, topLeftEdgeMidpoint.y);
            shape.quadTo(topCorner.x, topCorner.y, topRightEdgeMidpoint.x, topRightEdgeMidpoint.y);
            shape.lineTo(topCorner.x, topCorner.y);
            shape.lineTo(topLeftEdgeMidpoint.x, topLeftEdgeMidpoint.y);
            shape.closePath();
            g.setColor(WaterDrawer.WATER_COLOR);
            g.fill(shape);
        }
    }
}

