/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.Hectare;
import hectare.SoundSystem;
import hectare.view.utilities.DialogUtilities;
import hectare.view.utilities.DrawUtilities;
import hectare.view.widgets.AbstractMenuWidget;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class WinGameMenu
extends AbstractMenuWidget<String> {
    private static final long serialVersionUID = 1L;
    private static final int TITLE_HEIGHT = 50;
    private static final int SUBTITLE_HEIGHT = 50;
    private static final int BUTTON_PADDING = 25;
    private static final String TITLE = "You Win!";
    private static final String SUBTITLE = "Your civilization has spread across the world!";
    private static final String CONTINUE_GAME = "Continue Game";
    private static final String MAIN_MENU = "Main Menu";
    private static final String QUIT_GAME = "Quit";
    private static final String WIN_SOUND = "applause.wav";
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 50;
    private final Shape continueGame = this.newCenteredButton("Continue Game", 150, 50, 25, 100);
    private final Shape mainMenu = this.newCenteredButton("Main Menu", 150, 50, 25, 0);
    private final Shape quitGame = this.newCenteredButton("Quit", 150, 50, 25, 0);

    public WinGameMenu(int width, int height) {
        super(width, height);
        SoundSystem.getInstance().playSound(WIN_SOUND);
    }

    @Override
    protected void drawBackground(Graphics2D g) {
        this.clearAll();
        Composite opaque = DrawUtilities.setOpacity(g, 0.75f);
        super.drawBackground(g);
        g.setComposite(opaque);
        g.setColor(Color.white);
        DrawUtilities.drawCenteredString(g, TITLE, new Rectangle(0, 0, this.getWidth(), 50));
        DrawUtilities.drawCenteredString(g, SUBTITLE, new Rectangle(0, 50, this.getWidth(), 50));
    }

    @Override
    protected void buttonWasClicked(String object, Shape s) {
        if (s == this.continueGame) {
            Hectare.popLayer();
        } else if (s == this.mainMenu) {
            DialogUtilities.promptForEndGame(this);
        } else if (s == this.quitGame) {
            DialogUtilities.promptForExit(this);
        }
    }
}

